context("regress output")

test_that("output from regress is as expected", {
  x <- cat("                        Model Summary                          \n\t--------------------------------------------------------------\n\tR                       0.909       RMSE                2.639 \n\tR-Squared               0.827       Coef. Var          13.135 \n\tAdj. R-Squared          0.808       MSE                 6.964 \n\tPred R-Squared          0.768       MAE                 1.907 \n\t--------------------------------------------------------------\n\t RMSE: Root Mean Square Error \n\t MSE: Mean Square Error \n\t MAE: Mean Absolute Error \n\n\t                               ANOVA                                 \n\t--------------------------------------------------------------------\n\t                Sum of                                              \n\t               Squares        DF    Mean Square      F         Sig. \n\t--------------------------------------------------------------------\n\tRegression     931.057         3        310.352    44.566    0.0000 \n\tResidual       194.991        28          6.964                     \n\tTotal         1126.047        31                                    \n\t--------------------------------------------------------------------\n\n\t                                  Parameter Estimates                                    \n\t----------------------------------------------------------------------------------------\n\t      model      Beta    Std. Error    Std. Beta      t        Sig      lower     upper \n\t----------------------------------------------------------------------------------------\n\t(Intercept)    37.106         2.111                 17.579    0.000    32.782    41.429 \n\t       disp    -0.001         0.010       -0.019    -0.091    0.929    -0.022     0.020 \n\t         hp    -0.031         0.011       -0.354    -2.724    0.011    -0.055    -0.008 \n\t         wt    -3.801         1.066       -0.617    -3.565    0.001    -5.985    -1.617 \n\t----------------------------------------------------------------------------------------")

  expect_output(print(ols_regress(mpg ~ disp + hp + wt, data = mtcars)), x)
})

test_that("output from regress when using lm object is as expected", {
  x <- cat("                        Model Summary                          \n\t--------------------------------------------------------------\n\tR                       0.909       RMSE                2.639 \n\tR-Squared               0.827       Coef. Var          13.135 \n\tAdj. R-Squared          0.808       MSE                 6.964 \n\tPred R-Squared          0.768       MAE                 1.907 \n\t--------------------------------------------------------------\n\t RMSE: Root Mean Square Error \n\t MSE: Mean Square Error \n\t MAE: Mean Absolute Error \n\n\t                               ANOVA                                 \n\t--------------------------------------------------------------------\n\t                Sum of                                              \n\t               Squares        DF    Mean Square      F         Sig. \n\t--------------------------------------------------------------------\n\tRegression     931.057         3        310.352    44.566    0.0000 \n\tResidual       194.991        28          6.964                     \n\tTotal         1126.047        31                                    \n\t--------------------------------------------------------------------\n\n\t                                  Parameter Estimates                                    \n\t----------------------------------------------------------------------------------------\n\t      model      Beta    Std. Error    Std. Beta      t        Sig      lower     upper \n\t----------------------------------------------------------------------------------------\n\t(Intercept)    37.106         2.111                 17.579    0.000    32.782    41.429 \n\t       disp    -0.001         0.010       -0.019    -0.091    0.929    -0.022     0.020 \n\t         hp    -0.031         0.011       -0.354    -2.724    0.011    -0.055    -0.008 \n\t         wt    -3.801         1.066       -0.617    -3.565    0.001    -5.985    -1.617 \n\t----------------------------------------------------------------------------------------")

  expect_output(print(ols_regress(lm(mpg ~ disp + hp + wt, data = mtcars))), x)
})
