% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{embed}
\alias{embed}
\title{Generate embedding for inputs}
\usage{
embed(
  model,
  input,
  truncate = TRUE,
  normalize = TRUE,
  keep_alive = "5m",
  endpoint = "/api/embed",
  host = NULL,
  ...
)
}
\arguments{
\item{model}{A character string of the model name such as "llama3".}

\item{input}{A vector of characters that you want to get the embeddings for.}

\item{truncate}{Truncates the end of each input to fit within context length. Returns error if FALSE and context length is exceeded. Defaults to TRUE.}

\item{normalize}{Normalize the vector to length 1. Default is TRUE.}

\item{keep_alive}{The time to keep the connection alive. Default is "5m" (5 minutes).}

\item{endpoint}{The endpoint to get the vector embedding. Default is "/api/embeddings".}

\item{host}{The base URL to use. Default is NULL, which uses Ollama's default base URL.}

\item{...}{Additional options to pass to the model.}
}
\value{
A numeric matrix of the embedding. Each column is the embedding for one input.
}
\description{
Supercedes the \code{embeddings()} function.
}
\examples{
\dontshow{if (test_connection()$status_code == 200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
embed("nomic-embed-text:latest", "The quick brown fox jumps over the lazy dog.")
# pass multiple inputs
embed("nomic-embed-text:latest", c("Good bye", "Bye", "See you."))
# pass model options to the model
embed("nomic-embed-text:latest", "Hello!", temperature = 0.1, num_predict = 3)
\dontshow{\}) # examplesIf}
}
\references{
\href{https://github.com/ollama/ollama/blob/main/docs/api.md#generate-embeddings}{API documentation}
}
