% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_acoustic_data.R
\name{feature_acoustic_data}
\alias{feature_acoustic_data}
\title{Summarize information about file format in an acoustic data set}
\usage{
feature_acoustic_data(path = ".", digits = 2)
}
\arguments{
\item{path}{Character string containing the directory path where the sound files are located. Default is \code{"."} (current working directory).}

\item{digits}{Numeric vector of length 1 with the number of decimals to include. Default is 2.}
}
\value{
The function prints a summary of the format of the files in an acoustic data set.
}
\description{
\code{feature_acoustic_data} summarizes information about file format in an acoustic data set
}
\details{
The function summarizes information about file format in an acoustic data set. It provides information about the number of files, file formats, sampling rates, bit depts, channels, duration and file size (in MB). For file format, sampling rate, bit depth and number of channels the function includes information about the number of files for each format (e.g. '44.1 kHz (2)' means 2 files with a sampling rate of 44.1 kHz).
}
\examples{
{
# load data and save example files into temporary working directory
data("lbh1", "lbh2", "lbh_reference")
writeWave(lbh1, file.path(tempdir(), "lbh1.wav"))
writeWave(lbh2, file.path(tempdir(), "lbh2.wav"))

# summary across sound files
feature_acoustic_data(path = tempdir())
}
}
\references{
{
Araya-Salas, M. (2021), ohun: diagnosing and optimizing automated sound event detection. R package version 0.1.0.
}
}
\seealso{
\code{\link{feature_reference}}
}
\author{
Marcelo Araya-Salas \email{marcelo.araya@ucr.ac.cr})
}
