% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{ftext}
\alias{ftext}
\title{Formatted chunk of text}
\usage{
ftext(text, prop = NULL)
}
\arguments{
\item{text}{text value, a single character value}

\item{prop}{formatting text properties returned by \link{fp_text}. It also can be NULL in
which case, no formatting is defined (the default is applied).}
}
\description{
Format a chunk of text with text formatting properties (bold, color, ...).
The function allows you to create pieces of text formatted the way you want.
}
\section{usage}{

You can use this function in conjunction with \link{fpar} to create paragraphs
consisting of differently formatted text parts. You can also use this
function as an \emph{r chunk} in an R Markdown document made with package
officedown.
}

\examples{
ftext("hello", fp_text())

properties1 <- fp_text(color = "red")
properties2 <- fp_text(bold = TRUE, shading.color = "yellow")
ftext1 <- ftext("hello", properties1)
ftext2 <- ftext("World", properties2)
paragraph <- fpar(ftext1, " ", ftext2)

x <- read_docx()
x <- body_add(x, paragraph)
print(x, target = tempfile(fileext = ".docx"))
}
\seealso{
\link{fp_text}

Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_footnoteref}()},
\code{\link{run_footnote}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()}
}
\concept{run functions for reporting}
