% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_vector_entry.R
\name{insert_vector_entry}
\alias{insert_vector_entry}
\title{Insert entry in vector}
\usage{
insert_vector_entry(v, x, p)
}
\arguments{
\item{v}{[\code{atomic()}]\cr
A \code{vector}.}

\item{x}{[\code{atomic(1)}]\cr
The entry to be added.}

\item{p}{[\verb{integer())}]\cr
The position(s) where to add the value, one or more of:
\itemize{
\item \code{p = 0} appends the value left
\item \code{p = length(v)} appends the value right
\item \code{p = n} inserts the value between the \code{n}-th and
\code{(n + 1)}-th entry of \code{v}.
}}
}
\value{
A \code{vector}.
}
\description{
This function inserts a value into a vector.
}
\examples{
v <- 1:3
x <- 0
insert_vector_entry(v, x, 0)
insert_vector_entry(v, x, 1)
insert_vector_entry(v, x, 2)
insert_vector_entry(v, x, 3)

### also multiple positions
insert_vector_entry(v, x, 0:3)

### also trivial case
insert_vector_entry(integer(), integer(), integer())
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{check_probability_vector}()},
\code{\link{chunk_vector}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{split_vector_at}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{transformation}
