% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_vector.R
\name{chunk_vector}
\alias{chunk_vector}
\title{Split a vector into chunks}
\usage{
chunk_vector(x, n, type = 1, strict = FALSE)
}
\arguments{
\item{x}{[atomic()`]\cr
A vector of elements.}

\item{n}{[\code{integer(1)}]\cr
A number smaller or equal \code{length(x)}.}

\item{type}{[\code{1} | \code{2}]\cr
Either
\itemize{
\item \code{1} (default) to split \code{x} into \code{n} chunks of equal size,
\item or \code{2} to split \code{x} into chunks of size \code{n}.
}}

\item{strict}{[\code{logical(1)}]\cr
Set to \code{TRUE} to fail if \code{length(x)} is not a multiple of \code{n},
or \code{FALSE} (default), else.}
}
\value{
A \code{list}.
}
\description{
This function either
\itemize{
\item splits a vector into \code{n} chunks of equal size (\code{type = 1}),
\item splits a vector into chunks of size \code{n} (\code{type = 2}).
}
}
\examples{
x <- 1:12
chunk_vector(x, n = 3, type = 1)
chunk_vector(x, n = 3, type = 2)
try(chunk_vector(x, n = 5, strict = TRUE))
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{check_probability_vector}()},
\code{\link{insert_vector_entry}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{transformation}
