% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_helpers.R
\name{variable_name}
\alias{variable_name}
\title{Determine variable name}
\usage{
variable_name(variable, fallback = "unnamed")
}
\arguments{
\item{variable}{Any object.}

\item{fallback}{A \code{character}, a fallback if for some reason the actual variable name
(which must be a single \code{character}) cannot be determined.}
}
\value{
A \code{character}, the variable name.
}
\description{
This function tries to determine the name of a variable passed to a
\code{function}.
}
\examples{
variable_name(a)
f <- function(x) variable_name(x)
f(x = a)

}
