% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rwishart_cpp}
\alias{rwishart_cpp}
\title{Draw from Wishart distribution}
\usage{
rwishart_cpp(df, scale, inv = FALSE)
}
\arguments{
\item{df}{An \code{integer}, the degrees of freedom.
Must be greater or equal \code{p}.}

\item{scale}{A \code{matrix}, the scale matrix of dimension \code{p} x \code{p}.
Must be a covariance matrix.}

\item{inv}{A \code{logical}, if \code{TRUE} the density of the Inverse-Wishart
distribution is returned.
By default, \code{inv = FALSE}.}
}
\value{
A \code{matrix}, the random draw.
}
\description{
This function draws from a Wishart or Inverse-Wishart distribution.
}
\details{
The Wishart distribution is a generalization to multiple dimensions of the
gamma distributions and draws from the space of covariance matrices.
Its expectation is \code{df * scale}, and its variance increases both in
\code{df} and in the values of \code{scale}.

This function performs no input checks. See \code{\link{rwishart}}
for the version with input checks.
}
\keyword{internal}
