% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.2m.111m.R
\name{od.2m.111m}
\alias{od.2m.111m}
\title{Optimal sample allocation identification for two-level multisite randomized
    trials investigating main and moderation effects with individual-level
    moderators}
\usage{
od.2m.111m(
  n = NULL,
  p = NULL,
  icc = NULL,
  r12 = NULL,
  r22m = NULL,
  c1 = NULL,
  c2 = NULL,
  c1t = NULL,
  omega = NULL,
  m = NULL,
  plots = TRUE,
  plot.by = list(n = "n", p = "p"),
  nlim = c(2, 50),
  plim = c(0.01, 0.99),
  varlim = NULL,
  nlab = NULL,
  plab = NULL,
  varlab = NULL,
  vartitle = NULL,
  verbose = TRUE,
  iter = 100,
  tol = 1e-10,
  q = 1,
  d = 0.1,
  gamma = 0.1,
  power = 0.8,
  random.slope = TRUE,
  d.p = c(0.1, 0.5),
  d.n = c(2, 1000),
  sig.level = 0.05,
  two.tailed = TRUE,
  Jlim = c(4, 1e+10),
  binary = TRUE,
  nrange = c(2, 10000),
  power.dis = 0,
  Q = 0.5,
  max.value = Inf,
  max.iter = 300,
  e = 1e-10,
  n.of.ants = 10,
  n.of.archive = 50,
  q.aco = 1e-04,
  xi = 0.5
)
}
\arguments{
\item{n}{The level-1 sample size per level-2 unit.}

\item{p}{The proportion of level-1 units within each level 2 unit
to be assigned to treatment.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22m}{The proportion of variance of site-specific treatment
effect explained by covariates.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c2}{The cost of sampling one level-2 unit (site).}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{omega}{The treatment-by-site variance of the outcome.}

\item{m}{Total budget, default is the total costs of sampling 60
sites.}

\item{plots}{Logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{plot.by}{Plot the variance by \code{n} and/or \code{p};
default value is plot.by = list(n = "n", p = "p").}

\item{nlim}{The plot range for n, default value is c(2, 50).}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{nlab}{The plot label for \code{n},
default value is "Level-1 Sample Size: n".}

\item{plab}{The plot label for \code{p},
default value is "Proportion Level-1 Units in Treatment: p".}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{vartitle}{The title of variance plot, default value is NULL.}

\item{verbose}{Logical; print the values of \code{n}
and \code{p} if TRUE, otherwise not; default value is TRUE.}

\item{iter}{Number of iterations; default value is 100.}

\item{tol}{Tolerance for convergence; default value is 1e-10.}

\item{q}{The number of covariates at level 2. Default is 1.}

\item{d}{Standardized effect size, default is 0.1.}

\item{gamma}{The standardized moderated treatment effect.}

\item{power}{Statistical power specified for the main effect, default is .80.}

\item{random.slope}{Logical, the model is a random slope one if TURE. Default
is TRUE.}

\item{d.p}{The initial sampling domains for p. Default is c(0.1, 0.5).}

\item{d.n}{The initial sampling domain for n. Default is c(2, 1000).}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{Jlim}{The range for solving the root of level-2 sample size
(\code{J}) numerically. Change the default values to a larger range
(e.g., starting with a smaller value) if
f() values at end points are not of opposite sign. For example,
use Jlim = c(1.5, 1e10).}

\item{binary}{Logical; binary moderator if TURE and continuous moderator if
FALSE. Default is TRUE.}

\item{nrange}{The range of the level-1 sample size per level-2 unit
that used to exclude unreasonable values. Default value is c(2, 10000).}

\item{power.dis}{Statistical power distance between main and moderation
effects. Default is 0. The power for moderation = power - power.dis.}

\item{Q}{The proportion of units in one group for the binary moderator.
Default is 0.5.}

\item{max.value}{Maximal value of optimization when used as
the stopping criterion. Default is -Inf.}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion.}

\item{e}{Maximum error value used when solution quality used as
the stopping criterion, default is 1e-10.}

\item{n.of.ants}{Number of ants used in each iteration after the initialization
of power analysis for calculating required budget, default value is 10.}

\item{n.of.archive}{Size of the solution archive, default is 100.}

\item{q.aco}{Locality of the ACO search (0,1), default is 0.0001.}

\item{xi}{Convergence pressure (0, Inf), suggested: (0, 1), default is 0.5.}
}
\value{
Unconstrained or constrained optimal sample allocation (\code{n} and \code{p}).
    The function also returns statistical power,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of two-level
    multisite-randomized trials (MRTs) probing main and moderation effects
    with individual-level mediators identify the optimal sample allocations.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n})
    and the proportion of level-1 individuals/units assigned to
    the experimental group (\code{p}).
    This function solves the optimal \code{n} and/or \code{p}
    with and without a constraint.
}
\examples{
myod <- od.2m.111m(icc = .2, r12 = .5, r22m = .5,
                   c1 = 10, c1t = 100, c2 = 50, omega = .01, gamma = 0.1)
myod$out
}
