% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odin_validate.R
\name{odin_validate}
\alias{odin_validate}
\title{Validate an odin model}
\usage{
odin_validate(x, type = NULL, options = NULL)
}
\arguments{
\item{x}{An expression, character vector or filename with the odin
code}

\item{type}{An optional string indicating the the type of input -
must be one of \code{expression}, \code{file} or \code{text} if
provided.  This skips the type detection code used by odin and
makes validating user input easier.}

\item{options}{odin options; see \link{odin_options}.  The
primary options that affect the parse stage are \code{validate}
and \code{pretty}.}
}
\description{
Validate an odin model.  This function is closer to
\link{odin_parse_} than \link{odin_parse} because it
does not do any quoting of the code.  It is primarily intended for
use within other applications.
}
\details{
\code{odin_validate} will always return a list with the same
elements:

\describe{
\item{success}{A boolean, \code{TRUE} if validation was successful}

\item{result}{The intermediate representation, as returned by
\link{odin_parse_}, if the validation was successful,
otherwise \code{NULL}}

\item{error}{An error object if the validation was unsuccessful,
otherwise \code{NULL}.  This may be a classed odin error, in which
case it will contain source location information - see the
examples for details.}

\item{messages}{A list of messages, if the validation returned
any.  At present this is only non-fatal information about unused
variables.}
}
}
\examples{

# A successful validation:
odin::odin_validate(c("deriv(x) <- 1", "initial(x) <- 1"))

# A complete failure:
odin::odin_validate("")

# A more interesting failure
code <- c("deriv(x) <- a", "initial(x) <- 1")
res <- odin::odin_validate(code)
res

# The object 'res$error' is an 'odin_error' object:
res$error

# It contains information that might be used to display to a
# user information about the error:
unclass(res$error)

# Notes are raised in a similar way:
code <- c("deriv(x) <- 1", "initial(x) <- 1", "a <- 1")
res <- odin::odin_validate(code)
res$messages[[1]]
}
\author{
Rich FitzJohn
}
