% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odiff_run.R
\name{odiff_run}
\alias{odiff_run}
\title{Run odiff Command (Low-Level)}
\usage{
odiff_run(
  img1,
  img2,
  diff_output = NULL,
  threshold = 0.1,
  antialiasing = FALSE,
  fail_on_layout = FALSE,
  diff_mask = FALSE,
  diff_overlay = NULL,
  diff_color = NULL,
  diff_lines = FALSE,
  reduce_ram = FALSE,
  ignore_regions = NULL,
  timeout = 60
)
}
\arguments{
\item{img1}{Character; path to the first (baseline) image file.}

\item{img2}{Character; path to the second (comparison) image file.}

\item{diff_output}{Character or \code{NULL}; optional path for the diff output
image. Must have \code{.png} extension. If \code{NULL}, no diff image is created.}

\item{threshold}{Numeric; color difference threshold between 0.0 and 1.0.
Lower values are more precise. Default is 0.1.}

\item{antialiasing}{Logical; if \code{TRUE}, ignore antialiased pixels.
Default is \code{FALSE}.}

\item{fail_on_layout}{Logical; if \code{TRUE}, fail immediately if images have
different dimensions. Default is \code{FALSE}.}

\item{diff_mask}{Logical; if \code{TRUE}, output only the changed pixels in the
diff image. Default is \code{FALSE}.}

\item{diff_overlay}{Logical or numeric; if \code{TRUE} or a number between 0 and
1, add a white shaded overlay to the diff image for easier reading.
Default is \code{NULL} (no overlay).}

\item{diff_color}{Character; hex color for highlighting differences
(e.g., \code{"#FF0000"}). Default is \code{NULL} (uses odiff default, red).}

\item{diff_lines}{Logical; if \code{TRUE}, include line numbers containing
different pixels in the output. Default is \code{FALSE}.}

\item{reduce_ram}{Logical; if \code{TRUE}, use less memory but run slower.
Useful for very large images. Default is \code{FALSE}.}

\item{ignore_regions}{A list of regions to ignore during comparison. Each
region should be a list with \code{x1}, \code{y1}, \code{x2}, \code{y2} components, or use
\code{\link[=ignore_region]{ignore_region()}} to create them. Can also be a data.frame with these
columns.}

\item{timeout}{Numeric; timeout in seconds for the odiff process.
Default is 60.}
}
\value{
A list with the following components:
\describe{
\item{match}{Logical; \code{TRUE} if images match, \code{FALSE} otherwise.}
\item{reason}{Character; one of \code{"match"}, \code{"pixel-diff"},
\code{"layout-diff"}, or \code{"error"}.}
\item{diff_count}{Integer; number of different pixels, or \code{NA}.}
\item{diff_percentage}{Numeric; percentage of different pixels, or \code{NA}.}
\item{diff_lines}{Integer vector of line numbers with differences,
or \code{NULL}.}
\item{exit_code}{Integer; odiff exit code (0 = match, 21 = layout diff,
22 = pixel diff).}
\item{stdout}{Character; raw stdout output.}
\item{stderr}{Character; raw stderr output.}
\item{img1}{Character; path to first image.}
\item{img2}{Character; path to second image.}
\item{diff_output}{Character or \code{NULL}; path to diff image if created.}
\item{duration}{Numeric; time elapsed in seconds.}
}
}
\description{
Direct wrapper around the odiff CLI with zero external dependencies.
Returns a structured list with comparison results.
}
\examples{
\dontrun{
# Basic comparison
result <- odiff_run("baseline.png", "current.png")
result$match

# With diff output
result <- odiff_run("baseline.png", "current.png", "diff.png")

# With threshold and antialiasing
result <- odiff_run("baseline.png", "current.png",
                    threshold = 0.05, antialiasing = TRUE)

# Ignoring specific regions
result <- odiff_run("baseline.png", "current.png",
                    ignore_regions = list(
                      ignore_region(10, 10, 100, 50),
                      ignore_region(200, 200, 300, 300)
                    ))
}
}
\seealso{
\code{\link[=compare_images]{compare_images()}} for a higher-level interface,
\code{\link[=ignore_region]{ignore_region()}} for creating ignore regions.
}
