% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbListFields,OdbcConnection,character-method}
\alias{dbListFields,OdbcConnection,character-method}
\alias{dbListFields}
\title{List field names of a remote table}
\usage{
\S4method{dbListFields}{OdbcConnection,character}(conn, name,
  catalog_name = NULL, schema_name = NULL, column_name = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{a character string with the name of the remote table.}

\item{catalog_name}{The name of the catalog to return, the default returns all catalogs.}

\item{schema_name}{The name of the schema to return, the default returns all schemas.}

\item{column_name}{The name of the column to return, the default returns all columns.}

\item{...}{Other parameters passed on to methods.}
}
\value{
a character vector
}
\description{
List field names of a remote table
}
\details{
\code{\%} can be used as a wildcard in any of the search parameters to
match 0 or more characters. \code{_} can be used to match any single character.
}
\seealso{
\code{\link[=dbColumnInfo]{dbColumnInfo()}} to get the type of the fields.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListObjects}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
