% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_module.R
\name{input_ui}
\alias{input_ui}
\alias{citation_ui}
\alias{output_ui}
\alias{input_server}
\alias{output_server}
\title{NOAA data module}
\usage{
input_ui(id, citation = NULL, extended = TRUE)

citation_ui(id)

output_ui(id)

input_server(id, cache = FALSE)

output_server(id, NOAA, variable)
}
\arguments{
\item{id}{Namespace id shiny module.}

\item{citation}{Additional space for citation element.}

\item{extended}{Boolean whether to build the extended module
(default = \code{TRUE}).}

\item{cache}{Caching the extracted NOAA file in the package's \code{extdata}
directory (default = \code{FALSE}). Size of individual files is around 12 Mb. Use
\code{\link[=list_NOAA]{list_NOAA()}} to list cached data resources.}

\item{NOAA}{Reactive value for the dataset containing the locations
coordinates.}

\item{variable}{Reactivevalues for selected variable information.}
}
\value{
Shiny module.
}
\description{
These shiny modules control loading of data from the NOAA world ocean atlas
(\code{input_ui()} + \code{input_server()}). In addition, the \code{output_ui()} +
\code{output_server()} can be used to export the filtered data in csv format. The
\code{citation_ui()} provides the associated references of the dataset currently
loaded.
}
\examples{

# run data module stand-alone
if (curl::has_internet() && interactive()) {

library(oceanexplorer)
library(shiny)

# data
NOAA <- get_NOAA("oxygen", 1, "annual")

# gui
ui <- fluidPage(input_ui("NOAA"), plot_ui("worldmap"))

# server

server <-function(input, output, session) {
 # table
 NOAA <- input_server("NOAA")
 # plot data
 output_plot <- plot_server("worldmap", NOAA$data, reactive(NULL))
}

# run app
shinyApp(ui, server)
}
}
