% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oceFormat.R
\name{oceFormat}
\alias{oceFormat}
\title{Format ordered composite endpoint.}
\usage{
oceFormat(
  data,
  oceTime,
  oceStatus,
  group,
  id = NULL,
  oceNames = NULL,
  outputDataFrame = FALSE
)
}
\arguments{
\item{data}{data.frame name, must have variables with names listed in
\code{oceTime}, \code{oceStatus}, \code{group}}

\item{oceTime}{character vector with ordered (primary is first) names of
different time-to-event variables.}

\item{oceStatus}{character vector with ordered names of status
(0=censored, 1=event) variables.}

\item{group}{name of group variable.}

\item{id}{name of ID variable, NULL creates integer IDs.}

\item{oceNames}{long names of ordered endpoints, NULL uses \code{oceTime}.}

\item{outputDataFrame}{logical, output a data.frame in the list, defaults to
FALSE for speed in the bootstrap.}
}
\value{
A list with the following elements:
\describe{
 \item{timeMatrix}{n by k matrix with input values for k time-to-event values
  for each of n individuals}
  \item{statusMatrix}{n by k matrix of status values}
  \item{Z}{n vector of group variable with elements either 0 or 1}
  \item{oceNames}{k vector of long oceNames (for plotting labels)}
  \item{id}{m vector of individual ids, one element for each
     interval, so m>n}
  \item{group}{m vector of group values, either 0 or 1}
 \item{status}{m vector of status for each interval}
 \item{START}{m vector, START of interval}
 \item{STOP}{m vector, end of interval}
 \item{TAU}{maximum of the time-to-event outcomes}
 \item{IZMatrix}{m by k matrix, with jth column an indicator of representing
    ordering score 'time' for the jth endpoint}
 \item{data}{a data.frame output if outputDataFrame=TRUE, with variables:
   id, group, status, START, STOP, IZ1,...,IZk (columns of IZMatrix)}
 }
}
\description{
Usually called from within \code{\link{oceTest}}. Input data.frame
with one row for each individual and columns for
k time-to-event outcomes, k status variables, and a group variable.
Format output so that each individual has several rows representing
different intervals at risk. Returns a list with elements used for later
calculations.
}
\examples{
 d.temp<-data.frame(T1=c(1,4,3,6),s1=c(0,0,1,0),T2=c(4,1,5,3),
   s2=c(1,0,0,1),z=c(0,0,1,1))
 d.temp
 x<-oceFormat(data=d.temp,oceTime=c("T1","T2"),oceStatus=c("s1","s2"),
   group="z",outputDataFrame=TRUE)
 # put time to second event starting at TAU
 x$TAU
 x$data

}
