% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.woce.R
\name{woceNames2oceNames}
\alias{woceNames2oceNames}
\title{Translate WOCE Data Names to Oce Data Names}
\usage{
woceNames2oceNames(names)
}
\arguments{
\item{names}{vector of strings holding WOCE-style names.}
}
\value{
vector of strings holding \code{oce}-style names.
}
\description{
Translate WOCE-style names to \code{oce} names, using \code{\link[=gsub]{gsub()}}
to match patterns. For example, the pattern \code{"CTDOXY.*"} is taken
to mean \code{oxygen}.
}
\references{
Several online sources list WOCE names. An example is
\verb{https://cchdo.github.io/hdo-assets/documentation/manuals/pdf/90_1/chap4.pdf}
}
\seealso{
Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv.gz}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfilesRBR}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv.gz}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd.gz}},
\code{\link{d201211_0011.cnv.gz}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.aml}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.saiv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.ssda}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}

Other functions that interpret variable names and units from headers: 
\code{\link{ODFNames2oceNames}()},
\code{\link{cnvName2oceName}()},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{unitFromStringRsk}()},
\code{\link{unitFromString}()},
\code{\link{woceUnit2oceUnit}()}
}
\author{
Dan Kelley
}
\concept{functions that interpret variable names and units from headers}
\concept{things related to ctd data}
