% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{download.amsr}
\alias{download.amsr}
\title{Download and Cache an amsr File}
\usage{
download.amsr(
  year = NULL,
  month,
  day,
  destdir = ".",
  server = "https://data.remss.com/amsr2/ocean/L3/v08.2",
  type = "3day",
  debug = 0
)
}
\arguments{
\item{year, month, day}{a specification of the desired observation time.
There are 3 choices for this specification.  (a) If \code{year} is an object
created by \code{\link[=as.Date]{as.Date()}}, then that specifies the time, and so \code{month}
and \code{day} are ignored.  This scheme can be convenient for creating a
sequence of images, starting at a particular date, because adding 1
to an object of class \code{Date} increases the time by 1 day, saving
the user from having to know how many days are in any given month.
(b) If \code{year} is an integer, then it is taken to be the year, and
the user must also specify \code{month} and \code{day}, also integers. (c)
If \code{year} is NULL (which is the default), then the focus is set to
the most recent date, but this depends on the value of
\code{type} (see next).  If \code{type} is \code{"3day"}, \code{"daily"} or \code{"weekly"},
or just the first two of them if \code{type} is \code{"monthly"}.  If these
things are provided, then they just match exactly the values in the
sought-after file on the remote server.  If \code{year} is NULL, then
\code{\link[=download.amsr]{download.amsr()}} constructs a URL that ought to be the most recent
available file: 3 days prior to the present date (if \code{type} is
\code{"3day"} or \code{"daily"}), the Saturday two weeks prior to the
present date (if \code{type} is \code{"weekly"}), or two months in the
past (if \code{type} is \code{"monthly"}).}

\item{destdir}{A string naming the directory in which to cache the downloaded file.
The default is to store in the present directory, but many users find it more
helpful to use something like \code{"~/data/amsr"} for this, to collect all
downloaded amsr files in one place.}

\item{server}{A string naming the server from which data
are to be acquired. See \dQuote{History}.}

\item{type}{character value indicating where to get the data.  This may be
\code{"3day"} (the default), for a composite covering 3 days of observation, which
removes most viewing-path and cloud blanks, \code{"daily"} for a daily reading,
\code{"weekly"} for a composite covering a week, or \code{"monthly"} for a composite
covering a month.  In the \code{"daily"} case, the data arrays are 3D, with the
third dimension representing ascending and descending traces, but in all the
other cases, the arrays are 2D.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
\code{download.amsr} returns a character value holding the full pathname
of the downloaded file.
}
\description{
If the file is already present in \code{destdir}, then it is not
downloaded again. The default \code{destdir} is the present directory,
but it probably makes more sense to use something like \code{"~/data/amsr"}
to make it easy for scripts in other directories to use the cached data.
The file is downloaded with \code{\link[=download.file]{download.file()}}.  Please read the
\sQuote{History} section for important details on how \code{\link[=download.amsr]{download.amsr()}}
and also \code{\link[=read.amsr]{read.amsr()}} have had be altered over the years, to deal
with changes in the directory structure and file format on the
server from which files are downloaded.
}
\section{History}{

Until 25 March 2017, the default server was
\code{"ftp.ssmi.com/amsr2/bmaps_v07.2"}, but this was changed when the author
discovered that this FTP site had been changed to require users to create
accounts to register for downloads.  The default was changed to
\code{"http://data.remss.com/amsr2/bmaps_v07.2"} on the named date.
This site was found by a web search, but it seems to provide proper data.
It is assumed that users will do some checking on the best source.

On 23 January 2018, it was noticed that the server-url naming convention
had changed, e.g.
\verb{http://data.remss.com/amsr2/bmaps_v07.2/y2017/m01/f34_20170114v7.2.gz}
becoming
\verb{http://data.remss.com/amsr2/bmaps_v08/y2017/m01/f34_20170114v8.gz}

On 26 July 2023, it was noticed that the server-url naming convention
had changed again, requiring not only the alteration of the default
\code{server} value but also the addition of a new parameter named \code{type}.
Worse yet -- much worse -- the file format is now changed from a gzipped
format to a NetCDF format, and this will require a complete rewriting
of \code{\link[=read.amsr]{read.amsr()}}.
}

\section{Sample of Usage}{

\preformatted{
# The download may take up to about a minute.
f <- download.amsr(2023, 7, 27, destdir="~/data/amsr")
d <- read.amsr(f)
plot(d)
mtext(d[["filename"]], side=3, line=0, adj=0)
}
}

\seealso{
Other functions that download files: 
\code{\link{download.coastline}()},
\code{\link{download.met}()},
\code{\link{download.topo}()}

Other functions that plot oce data: 
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plot,xbt-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr-class}},
\code{\link{amsr}},
\code{\link{composite,amsr-method}},
\code{\link{plot,amsr-method}},
\code{\link{read.amsr}()},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}
}
\author{
Dan Kelley
}
\concept{functions that download files}
\concept{functions that plot oce data}
\concept{things related to amsr data}
