% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\name{read.cm}
\alias{read.cm}
\title{Read a CM file}
\usage{
read.cm(
  file,
  from = 1,
  to,
  by = 1,
  tz = getOption("oceTz"),
  type = c("s4"),
  longitude = NA,
  latitude = NA,
  debug = getOption("oceDebug"),
  encoding = "latin1",
  monitor = FALSE,
  processingLog
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.}

\item{from}{index number of the first measurement to be read, or the time of
that measurement, as created with \code{\link[=as.POSIXct]{as.POSIXct()}} (hint: use
\code{tz="UTC"}).}

\item{to}{indication of the last measurement to read, in a format matching that
of \code{from}.}

\item{by}{an indication of the stride length to use while walking through the
file. If this is an integer, then \code{by-1} measurements are skipped between
each pair of profiles that is read. This may not make much sense, if the data
are not equi-spaced in time.  If \code{by} is a string representing a time
interval, in colon-separated format, then this interval is divided by the
sampling interval, to get the stride length. \emph{BUG:} if the data are not
equi-spaced, then odd results will occur.}

\item{tz}{character string indicating time zone to be assumed in the data.}

\item{type}{character string indicating type of file (ignored at present).}

\item{longitude}{optional signed number indicating the longitude in degrees
East.}

\item{latitude}{optional signed number indicating the latitude in degrees North.}

\item{debug}{a flag that turns on debugging.  The value indicates the depth
within the call stack to which debugging applies.}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}

\item{monitor}{ignored.}

\item{processingLog}{if provided, the action item to be stored in the log.  This
parameter is typically only provided for internal calls; the default that it
provides is better for normal calls by a user.}
}
\value{
An \linkS4class{cm} object.

The \code{data} slot will contain all the data in the file, with names
determined from the tokens in line 3 in that file, passed through
\code{\link[=make.names]{make.names()}}, except that
\code{Vnorth} is renamed \code{v} (after conversion from cm/s to m/s),
\code{Veast} is renamed \code{u} (after conversion from cm/s to m/s),
\code{Cond} is renamed \code{conductivity},
\code{T.Temp} is renamed \code{temperature}
and
\code{Sal} is renamed \code{salinity}, and a new
column named \code{time} (a POSIX time) is constructed
from the information in the file header, and another named
\code{pressure} is constructed from the column named \code{Depth}.
At least in the single file studied in the creation of this function,
there are some columns that are unnamed in line 3 of the header;
these yield data items with names \code{X}, \code{X.1}, etc.
}
\description{
Read a current-meter data file, producing a \linkS4class{cm} object.
}
\details{
There function has been tested on only a single file, and the data-scanning
algorithm was based on visual inspection of that file.  Whether it will work
generally is an open question. It should be noted that the sample file had
several odd characteristics, some of which are listed below.
\itemize{
\item file contained two columns named \code{"Cond"}, which was guessed
to stand for conductivity. Since only the first contained data, the second was
ignored, but this may not be the case for all files.
\item The unit for \code{"Cond"} was stated in the file to be \code{"mS"},
which makes no sense, so the unit was assumed to be mS/cm.
\item The file contained a column named \code{"T-Temp"}, which is not
something the author has seen in his career. It was assumed to stand for
in-situ temperature.
\item The file contained a column named \code{"Depth"}, which is not something
an instrument can measure. Presumably it was calculated from pressure (with
what atmospheric offset, though?) and so pressure was inferred from it using
\code{\link[=swPressure]{swPressure()}}.
\item The file contained several columns that lacked names. These were ignored.
\item The file contained several columns that seem to be derived from the
actual measured data, such as \code{"Speed"}, \code{"Dir"}, \code{"N-S Dist"},
etc. These are ignored.
\item The file contained several columns that were basically a mystery to the
author, e.g. \code{"Hx"}, \code{"Hy"}, \code{"Vref"}, etc. These were ignored.
}

Based on such considerations, \code{\link[=read.cm]{read.cm()}} reads only the columns that
were reasonably well-understood based on the sample file. Users who need more
columns should contact the author. And a user who could produce a document
explaining the data format would be especially appreciated!
}
\section{Historical note}{

Prior to late July, 2016, the direction of current flow was stored in the
return value, but it is no longer stored, since it can be derived from the
\code{u} and \code{v} values.
}

\section{Changes}{

\itemize{
\item On 2023-02-09 an item named \code{north} was added to the \code{metadata} slot.  This
is initialized to \code{"magnetic"} by \code{\link[=read.cm]{read.cm()}}, but this is really just a
guess, and users ought to consider using \code{\link[=applyMagneticDeclination]{applyMagneticDeclination()}} to take
magnetic declination into account.
}
}

\examples{
\dontrun{
  library(oce)
  cm <- read.oce("cm_interocean_0811786.s4a.tab")
  summary(cm)
  plot(cm)
}

}
\seealso{
Other things related to cm data: 
\code{\link{[[,cm-method}},
\code{\link{[[<-,cm-method}},
\code{\link{applyMagneticDeclination,cm-method}},
\code{\link{as.cm}()},
\code{\link{cm-class}},
\code{\link{cm}},
\code{\link{plot,cm-method}},
\code{\link{rotateAboutZ}()},
\code{\link{subset,cm-method}},
\code{\link{summary,cm-method}}
}
\author{
Dan Kelley
}
\concept{things related to cm data}
