% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{beamUnspreadAdp}
\alias{beamUnspreadAdp}
\title{Adjust ADP Signal for Spherical Spreading}
\usage{
beamUnspreadAdp(
  x,
  count2db = c(0.45, 0.45, 0.45, 0.45),
  asMatrix = FALSE,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{x}{an \linkS4class{adp} object.}

\item{count2db}{a set of coefficients, one per beam, to convert from beam
echo intensity to decibels.}

\item{asMatrix}{a boolean that indicates whether to return a numeric matrix,
as opposed to returning an updated object (in which the matrix is cast to a
raw value).}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
An \linkS4class{adp} object.
}
\description{
Compensate ADP signal strength for spherical spreading.
}
\details{
First, beam echo intensity is converted from counts to decibels, by
multiplying by \code{count2db}.  Then, the signal decrease owing to
spherical spreading is compensated for by adding the term
\eqn{20\log10(r)}{20*log10(r)}, where \eqn{r}{r} is the distance from the
sensor head to the water from which scattering is occurring.  \eqn{r}{r} is
given by \code{x[["distance"]]}.
}
\examples{
library(oce)
data(adp)
plot(adp, which=5) # beam 1 echo intensity
adp.att <- beamUnspreadAdp(adp)
plot(adp.att, which=5) # beam 1 echo intensity
# Profiles
par(mar=c(4, 4, 1, 1))
a <- adp[["a", "numeric"]]             # second arg yields matrix return value
distance <- adp[["distance"]]
plot(apply(a,2,mean), distance, type='l', xlim=c(0,256))
lines(apply(a,2,median), distance, type='l',col='red')
legend("topright",lwd=1,col=c("black","red"),legend=c("original","attenuated"))
# Image
plot(adp.att, which="amplitude",col=oce.colorsViridis(100))

}
\references{
The coefficient to convert to decibels is a personal
communication.  The logarithmic term is explained in textbooks on acoustics,
optics, etc.
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley
}
\concept{things related to adp data}
