% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsk.R
\docType{methods}
\name{plot,rsk-method}
\alias{plot,rsk-method}
\alias{plot.rsk}
\title{Plot Rsk Data}
\usage{
\S4method{plot}{rsk}(x, which = "timeseries", tlim, ylim, xlab, ylab,
  tformat, drawTimeRange = getOption("oceDrawTimeRange"),
  abbreviateTimeRange = getOption("oceAbbreviateTimeRange"),
  useSmoothScatter = FALSE, mgp = getOption("oceMgp"), mar = c(mgp[1]
  + 1.5, mgp[1] + 1.5, 1.5, 1.5), main = "",
  debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{\code{rsk} object, typically result of \code{\link{read.rsk}}.}

\item{which}{character indicating desired plot types.  These are
graphed in panels running down from the top of the page.  See
\dQuote{Details} for the meanings of various values of
\code{which}.}

\item{tlim}{optional limits for time axis.  If not provided, the value will be
inferred from the data.}

\item{ylim}{optional limits for the y axis.  If not provided, the
value will be inferred from the data.  (It is helpful to
specify this, if the auto-scaled value will be inappropriate,
e.g. if more lines are to be added later). Note that this is
ignored, unless \code{length(which) == 1} and \code{which}
corresponds to one of the data fields. If a multipanel plot of
a specific subset of the data fields is desired with
\code{ylim} control, it should be done panel by panel (see
Examples).}

\item{xlab}{optional label for x axis.}

\item{ylab}{optional label for y axis.}

\item{tformat}{optional argument passed to \code{\link{oce.plot.ts}}, for plot
types that call that function.  (See \code{\link{strptime}} for the format
used.)}

\item{drawTimeRange}{boolean that applies to panels with time as the horizontal
axis, indicating whether to draw the time range in the top-left margin of the
plot.}

\item{abbreviateTimeRange}{boolean that applies to panels with time as the
horizontal axis, indicating whether to abbreviate the second time in the time
range (e.g. skipping the year, month, day, etc. if it's the same as the start
time).}

\item{useSmoothScatter}{a boolean to cause \code{\link{smoothScatter}} to be
used for profile plots, instead of \code{\link{plot}}.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and
also for \code{par(mar)}, computed from this.  The default is tighter than the
R default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}("mar")}.}

\item{main}{main title for plot, used just on the top panel, if there are several panels.}

\item{debug}{a flag that turns on debugging, if it exceeds 0.}

\item{...}{optional arguments passed to plotting functions.}
}
\description{
Rsk data may be in many forms, and it is not easy to devise a general plotting
strategy for all of them. The present function is quite crude, on the
assumption that users will understand their own datasets, and that they can
devise plots that are best-suited to their applications.  Sometimes, the
sensible scheme is to coerce the object into another form, e.g. using
\code{plot(as.ctd(rsk))} if the object contains CTD-like data.  Other times,
users should extract data from the \code{rsk} object and construct plots
themselves. The idea is to use the present function mainly to get an overview,
and for that reason, the default plot type (set by \code{which}) is a set of
time-series plots, because the one thing that is definitely known about
\code{rsk} objects is that they contain a \code{time} vector in their
\code{data} slot.
}
\details{
Plots produced are time series plots of the data in the
    object. The default, \code{which="timeseries"} plots all data
    fields, and over-rides any other specification. Specific fields
    can be plotted by naming the field,
    e.g. \code{which="temperature"} to plot a time series of just
    the temperature field.
}
\examples{
library(oce)
data(rsk)
plot(rsk) # default timeseries plot of all data fields

## A multipanel plot of just pressure and temperature with ylim
par(mfrow=c(2, 1))
plot(rsk, which="pressure", ylim=c(10, 30))
plot(rsk, which="temperature", ylim=c(2, 4))

}
\seealso{
The documentation for \code{\link{rsk-class}} explains the structure of
\code{rsk} objects, and also outlines the other functions dealing with them.

Other functions that plot oce data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,landsat-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to rsk data: \code{\link{[[,rsk-method}},
  \code{\link{[[<-,rsk-method}}, \code{\link{as.rsk}},
  \code{\link{read.rsk}}, \code{\link{rsk-class}},
  \code{\link{rskPatm}}, \code{\link{rskToc}},
  \code{\link{rsk}}, \code{\link{subset,rsk-method}},
  \code{\link{summary,rsk-method}}
}
\author{
Dan Kelley and Clark Richards
}
\concept{functions that plot oce data}
\concept{things related to rsk data}
