% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\name{decodeDataNamesArgo}
\alias{decodeDataNamesArgo}
\title{Convert Data Names From the Argo Convention to the Oce Convention}
\usage{
decodeDataNamesArgo(names)
}
\arguments{
\item{names}{vector of character strings containing names in the Argo convention.}
}
\value{
A character vector of the same length as \code{names}, but with
replacements having been made for all known quantities.
}
\description{
This function is used by \code{\link{read.argo}} to convert Argo-convention
data names to oce-convention names. The inference of names was done
by case-by-case inspection of some files. Eventually, it would make
sense to handle all the documented names listed in tables 2.2.2 
and 2.2.3 of [1].
}
\details{
The names are converted with
\code{\link{gsub}}, ignoring the case of the input strings. The procedure
is to first handle the items listed in the following table. After that,
the qualifiers 
\code{_ADJUSTED}, \code{_ERROR} and \code{_QC},
are translated to \code{Adjusted}, \code{Error}, and \code{QC}, respectively.
\itemize{
\item \code{BBP700} becomes \code{bbp700}
\item \code{BETA_BACKSCATTERING700} becomes \code{betaBackscattering700}
\item \code{BPHASE_OXY} becomes \code{bphaseOxygen}
\item \code{CHLA} becomes \code{chlorophyllA}
\item \code{CYCLE_NUMBER} becomes \code{cycleNumber}
\item \code{DATA_CENTRE} becomes \code{dataCentre} (note the spelling)
\item \code{DATA_MODE} becomes \code{dataMode}
\item \code{DATA_STATE_INDICATOR} becomes \code{dataStateIndicator}
\item \code{DC_REFERENCE} becomes \code{DCReference}
\item \code{DIRECTION} becomes \code{direction} (either \code{A} for ascending or \code{D} for descending)
\item \code{FIRMWARE_VERSION} becomes \code{firmwareVersion}
\item \code{INST_REFERENCE} becomes \code{instReference}
\item \code{JULD} becomes \code{juld} (and used to compute \code{time})
\item \code{JULD_QC_LOCATION} becomes \code{juldQCLocation}
\item \code{LATITUDE} becomes \code{latitude}
\item \code{LONGITUDE} becomes \code{longitude}
\item \code{PI_NAME} becomes \code{PIName}
\item \code{PLATFORM_NUMBER} becomes \code{id}
\item \code{POSITION_ACCURACY} becomes \code{positionAccuracy}
\item \code{POSITIONING_SYSTEM} becomes \code{positioningSystem}
\item \code{PROFILE} becomes \code{profile}
\item \code{PROJECT_NAME} becomes \code{projectName}
\item \code{STATION_PARAMETERS} becomes \code{stationParameters}
\item \code{UV_INTENSITY} becomes \code{UVIntensity}
\item \code{UV_INTENSITY_DARK_NITRATE} becomes \code{UVIntensityDarkNitrate}
\item \code{UV_INTENSITY_NITRATE} becomes \code{UVIntensityNitrate}
\item \code{WMO_INST_TYPE} becomes \code{WMOInstType}
}
}
\references{
1. Argo User's Manual Version 3.2, Dec 29th, 2015, available at
\samp{http://archimer.ifremer.fr/doc/00187/29825/40575.pdf}
(link checked 17 Nov 2016 several times in the months before, 
but failed 18 Nov 2016).
Tables 2.2.2 and 2.2.3 of this document lists the codes used in Argo netCDF files.
}

