% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\docType{methods}
\name{subset,cm-method}
\alias{subset,cm-method}
\title{Subset a CM Object}
\usage{
\S4method{subset}{cm}(x, subset, ...)
}
\arguments{
\item{x}{a \code{cm} object, i.e. inheriting from \code{\link{cm-class}}.}

\item{subset}{a condition to be applied to the \code{data} portion of \code{x}.
See \sQuote{Details}.}

\item{...}{ignored.}
}
\value{
A new \code{cm} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.
}
\examples{
library(oce)
data(cm)
plot(cm)
plot(subset(cm, time < mean(range(cm[['time']]))))

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{cm} data: \code{\link{[[,cm-method}},
  \code{\link{[[<-,cm-method}}, \code{\link{cm-class}},
  \code{\link{cm}}, \code{\link{plot,cm-method}},
  \code{\link{read.cm}}, \code{\link{summary,cm-method}}
}

