as.CTD <- function(S, T, p, header=NULL, filename=NA,ship=NA,scientist=NA,institute=NA,address=NA,
cruise=NA,station=NA,
date=NA,start.time=NA,
latitude=NA, longitude=NA,
recovery=NA,
water.depth=NA,
sample.interval=NA)
{
	if (length(p) == 1) # special case
		p = rep(p, length(S))
	data <- list(salinity=S, temperature=T, pressure=p, sigma=sw.sigma(S, T, p))
	processing.log <- list(time=c(Sys.time()), action=c("created by as.CTD()"))
	res <- list(header=header,
	      		filename=filename,
              	ship=ship,
              	scientist=scientist,
              	institute=institute,
              	address=address,
              	cruise=cruise,
              	station=station,
              	date=date,
	      		start.time=start.time,
              	latitude=latitude,
              	longitude=longitude,
              	recovery=recovery,
              	water.depth=water.depth,
              	sample.interval=sample.interval,
				processing.log=processing.log,
              	data=data);
  	class(res) <- "ctd"
	res
}
