% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_yieldamount}
\alias{get_yieldamount}
\title{get_yieldamount}
\usage{
get_yieldamount(apiKey = NULL, foodCode = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, the system environment variables will be checked.}

\item{foodCode}{The code indicating the food you want to search for. If null,
all foods and their corresponding yields are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing food names and food codes, yield amounts, and yield names.
}
\description{
Makes a query to the Canadian Nutrient File yieldamount endpoint. This endpoint returns
data from a list of food codes and corresponding yield amounts (yield from refuse and or
cooking losses). For instance, if you search the food id 1002 (Beef Gravy), it will tell
you that it takes 5.55 g dehydrated to make 60 mL and 9.26g to make 100 mL.
}
\examples{
\dontrun{
get_yieldamount()
get_yieldamount(foodCode = 57)
get_yieldamount(foodCode = 57, lang = "fr")}
}
