% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_affirm.R
\name{f_affirm}
\alias{f_affirm}
\alias{ff_affirm}
\title{Yes/No Convert Logical/Dummy Code}
\usage{
f_affirm(x, true = "Yes", false = "No", ...)

ff_affirm(...)
}
\arguments{
\item{x}{A vector of logical or dummy integers.  This vector will be coerced
to logical.}

\item{true}{A value for \code{TRUE} elements.}

\item{false}{A value for  \code{FALSE} elements.}

\item{\ldots}{ignored.}
}
\value{
Returns a string of either "Yes" or "No" elements.
}
\description{
Coerce logical (\code{TRUE}, \code{FALSE}) or or dummy coded elements (0/1)
to "Yes"/"No" elements.  This function is most useful in plot scales.
}
\examples{
f_affirm(c(TRUE, TRUE, FALSE))
f_affirm(c(1, 1, 0, 1, 0, 0, NA))
f_affirm(c(1, 0, 2, .3, -3))
f_affirm(rnorm(20) > 0)
f_affirm(rnorm(20) > 0, "A", "B")

\dontrun{
library(ggplot2)
library(dplyr)

## Without labels
data_frame(dummy = sample(c(TRUE, FALSE), 30, TRUE)) \%>\%
    count(dummy) \%>\%
    ggplot(aes(dummy, n)) +
        geom_bar(stat = 'identity')

## With labels
data_frame(dummy = sample(c(TRUE, FALSE), 30, TRUE)) \%>\%
    count(dummy) \%>\%
    ggplot(aes(dummy, n)) +
        geom_bar(stat = 'identity') +
        scale_x_discrete(labels = f_affirm)
}
}
\seealso{
\code{\link[base]{prettyNum}}
}
