% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_bulk}
\alias{get_bulk}
\title{Aggregate single-cell data into combined bulk expression and allele profile}
\usage{
get_bulk(
  count_mat,
  lambdas_ref,
  df_allele,
  gtf,
  subset = NULL,
  min_depth = 0,
  nu = 1,
  verbose = TRUE
)
}
\arguments{
\item{count_mat}{dgCMatrix Gene expression counts}

\item{lambdas_ref}{matrix Reference expression profiles}

\item{df_allele}{dataframe Single-cell allele counts}

\item{gtf}{dataframe Transcript gtf}

\item{subset}{vector Subset of cells to aggregate}

\item{min_depth}{integer Minimum coverage to filter SNPs}

\item{nu}{numeric Phase switch rate}

\item{verbose}{logical Verbosity}
}
\value{
dataframe Pseudobulk gene expression and allele profile
}
\description{
Aggregate single-cell data into combined bulk expression and allele profile
}
\examples{
bulk_example = get_bulk(
    count_mat = count_mat_example,
    lambdas_ref = ref_hca,
    df_allele = df_allele_example,
    gtf = gtf_hg38)
}
