% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_diff.r
\name{calc_mean_dist}
\alias{calc_mean_dist}
\title{Calculating the mean distances of each plot in the lineup.}
\usage{
calc_mean_dist(lineup.dat, var, met, pos, dist.arg = NULL, m = 20)
}
\arguments{
\item{lineup.dat}{lineup data of the lineup}

\item{var}{a vector of names of the variables to be used to calculate the mean distances}

\item{met}{distance metric needed to calculate the distance as a character}

\item{pos}{position of the true plot in the lineup}

\item{dist.arg}{a list or vector of inputs for the distance metric met; NULL by default}

\item{m}{number of plots in the lineup, by default m = 20}
}
\value{
the mean distances of each plot in the lineup
}
\description{
Distance metric is used to calculate the mean distance between the true plot
and all the null plots in a lineup. The mean distances of each null plot to all
the other null plots are calculated. The mean distances are returned for all the plots
in the lineup.
}
\examples{
if(require('dplyr')){
calc_mean_dist(lineup(null_permute('mpg'), mtcars, pos = 1), var = c('mpg', 'wt'),
met = 'reg_dist', pos = 1, m = 10)}
}
