% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig.R
\name{dig}
\alias{dig}
\title{Search for rules}
\usage{
dig(
  x,
  f,
  condition = everything(),
  focus = NULL,
  disjoint = NULL,
  min_length = 0,
  max_length = Inf,
  min_support = 0,
  min_focus_support = min_support,
  filter_empty_foci = FALSE,
  t_norm = "goguen",
  threads = 1,
  ...
)
}
\arguments{
\item{x}{a matrix or data frame. The matrix must be numeric (double) or logical.
If \code{x} is a data frame then each column must be either numeric (double) or
logical.}

\item{f}{the callback function executed for each generated condition. This
function may have some of the following arguments. Based on the present
arguments, the algorithm would provide information about the generated
condition:
- \code{condition} - a named integer vector of column indices that represent
the predicates of the condition. Names of the vector correspond to
column names;
- \code{support} - a numeric scalar value of the current condition's support;
- \code{indices} - a logical vector indicating the rows satisfying the condition;
- \code{weights} - (similar to indices) weights of rows to which they satisfy
the current condition;
- \code{pp} - a value of a contingency table, \code{condition & focus}.
\code{pp} is a named numeric vector where each value is a support of conjunction
of the condition with a foci column (see the \code{focus} argument to specify,
which columns). Names of the vector are foci column names.
- \code{pn} - a value of a contingency table, \verb{condition & neg focus}.
\code{pn} is a named numeric vector where each value is a support of conjunction
of the condition with a negated foci column (see the \code{focus} argument to
specify, which columns are foci) - names of the vector are foci column names.
- \code{np} - a value of a contingency table, \verb{neg condition & focus}.
\code{np} is a named numeric vector where each value is a support of conjunction
of the negated condition with a foci column (see the \code{focus} argument to
specify, which columns are foci) - names of the vector are foci column names.
- \code{nn} - a value of a contingency table, \verb{neg condition & neg focus}.
\code{nn} is a named numeric vector where each value is a support of conjunction
of the negated condition with a negated foci column (see the \code{focus}
argument to specify, which columns are foci) - names of the vector are foci
column names.
- \code{foci_supports} - (deprecated, use \code{pp} instead)
a named numeric vector of supports of foci columns
(see \code{focus} argument to specify, which columns are foci) - names of the
vector are foci column names.}

\item{condition}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as condition predicates}

\item{focus}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as focus predicates}

\item{disjoint}{an atomic vector of size equal to the number of columns of \code{x}
that specifies the groups of predicates: if some elements of the \code{disjoint}
vector are equal, then the corresponding columns of \code{x} will NOT be
present together in a single condition.}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the empty
condition is generated in the first place.}

\item{max_length}{The maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of conditions
is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{min_focus_support}{the minimum support of a focus, for the focus to be passed
to the callback function. The support of the focus is the relative frequency
of rows such that all condition predicates AND the focus are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{filter_empty_foci}{a logical scalar indicating whether to skip conditions,
for which no focus remains available after filtering by \code{min_focus_support}.
If \code{TRUE}, the condition is passed to the callback function only if at least
one focus remains after filtering. If \code{FALSE}, the condition is passed to the
callback function regardless of the number of remaining foci.}

\item{t_norm}{a t-norm used to compute conjunction of weights. It must be one of
\code{"goedel"} (minimum t-norm), \code{"goguen"} (product t-norm), or \code{"lukas"}
(Lukasiewicz t-norm).}

\item{threads}{the number of threads to use for parallel computation.}

\item{...}{Further arguments, currently unused.}
}
\value{
A list of results provided by the callback function \code{f}.
}
\description{
This is a general function that enumerates all conditions created from
data in \code{x} and calls the callback function \code{f} on each.
}
\author{
Michal Burda
}
