% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{row_normalised}
\alias{row_normalised}
\title{Normalise a square matrix by dividing elements by the sum of
off-diagonal entries row-wise. Note: sets diagonal to zero.}
\usage{
row_normalised(adj, keep_values = FALSE)
}
\arguments{
\item{adj}{Adjacency matrix to normalise}

\item{keep_values}{Whether to keep off-diagonal values
or normalise fully (defaults to \code{FALSE}).}
}
\value{
A matrix based on \code{adj} with zero diagonals
and off-diagonal elements sum to one.
}
\description{
Normalise a square matrix by dividing elements by the sum of
off-diagonal entries row-wise. Note: sets diagonal to zero.
}
\examples{
d <- 5
adj <- matrix(1, d, d)
row_normalised(adj)
}
