% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasen.R
\name{fasen_regression}
\alias{fasen_regression}
\title{Fasen's multivariate OU least squares regression
\doi{/10.1016/j.jeconom.2012.08.019}.}
\usage{
fasen_regression(data)
}
\arguments{
\item{data}{Multivariate ata to perform the estimation on.}
}
\value{
A \code{(d, d)} least square matrix.
}
\description{
Fasen's multivariate OU least squares regression
\doi{/10.1016/j.jeconom.2012.08.019}.
}
\examples{
n <- 100
d <- 10
delta_time <- 0.01
noise <- matrix(rnorm(n * d), ncol = d)
path <- construct_path(diag(10), noise, d, delta_time)
fasen_regression(path)
}
