% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globaltest.R
\name{globaltest}
\alias{globaltest}
\title{Testing the equality of the \emph{M} curves specific to each level}
\usage{
globaltest(formula, data = data, na.action = "na.omit", der,
  smooth = "kernel", weights = NULL, nboot = 500, h0 = -1, h = -1,
  nh = 30, kernel = "epanech", p = 3, kbin = 100, seed = NULL,
  cluster = TRUE, ncores = NULL, ...)
}
\arguments{
\item{formula}{An object of class \code{formula}: a sympbolic 
description of the model to be fitted. The details of model 
specification are given under 'Details'.}

\item{data}{A data frame or matrix containing the model response variable
and covariates required by the \code{formula}.}

\item{na.action}{A function which indicates what should happen when the 
data contain 'NA's. The default is 'na.omit'.}

\item{der}{Number which determines any inference process. 
By default \code{der} is \code{NULL}. If this term is \code{0}, 
the testing procedures is applied for the estimate. If it is \code{1} or
\code{2}, it is designed for the first or second derivative, respectively.}

\item{smooth}{Type smoother used: \code{smooth = "kernel"} for local polynomial
kernel smoothers and \code{smooth = "splines"} for splines using the 
\code{mgcv} package.}

\item{weights}{Prior weights on the data.}

\item{nboot}{Number of bootstrap repeats.}

\item{h0}{The kernel bandwidth smoothing parameter for the global effect (see
references for more details at the estimation). Large values of the bandwidth lead
to smoothed estimates; smaller values of the bandwidth lead lo undersmoothed estimates. 
By default, cross validation is used to obtain the bandwidth.}

\item{h}{The kernel bandwidth smoothing parameter for the partial effects.}

\item{nh}{Integer number of equally-spaced bandwidth on which the
\code{h} is discretised, to speed up computation.}

\item{kernel}{A character string specifying the desired kernel. 
Defaults to \code{kernel = "epanech"}, where the Epanechnikov
density function kernel will be used. Also, several types of kernel funcitons 
can be used:  triangular and Gaussian density function, 
with \code{"triang"} and \code{"gaussian"} term, respectively.}

\item{p}{Degree of polynomial to be used. Its value must be the value of
derivative + 1. The default value is 3 due to the function
returns the estimation, first and second derivative.}

\item{kbin}{Number of binning nodes over which the function 
is to be estimated.}

\item{seed}{Seed to be used in the bootstrap procedure.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the
bootstrap procedure is  parallelized (only for \code{smooth = "splines"}.
 Note that there are cases 
(e.g., a low number of bootstrap repetitions) that R will gain in
performance through serial computation. R takes time to distribute tasks
across the processors also it will need time for binding them all together
later on. Therefore, if the time for distributing and gathering pieces
together is greater than the time need for single-thread computing, it does
not worth parallelize.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores 
to be used is equal to the number of cores of the machine - 1.}

\item{\ldots}{Other options.}
}
\value{
The \eqn{T} value and the \eqn{p}-value  are returned. Additionally, 
it is shown the decision, accepted or rejected, of the global test. 
The null hypothesis is rejected if the \eqn{p}-value\eqn{< 0.05}.
}
\description{
This function can be used to test the equality of the 
\eqn{M} curves specific to each level.
}
\details{
\code{globaltest}  can be used to test the equality of the \eqn{M} 
curves specific to each level. This bootstrap based test assumes the  
following null hypothesis:

\deqn{H_0^r: m_1^r(\cdot) = \ldots = m_M^r(\cdot)}

versus the general alternative

\deqn{H_1^r: m_i^r (\cdot)  \ne m_j^r (\cdot) \quad  \rm{for} \quad \rm{some}
 \quad \emph{i}, \emph{j} \in \{ 1, \ldots, M\}. }

Note that, if \eqn{H_0} is not rejected, then the equality of critical points
will also accepted. 

To test the null hypothesis, it is used a test statistic, 
\eqn{T}, based on direct nonparametric estimates of the curves. 

If the null hypothesis is true, the \eqn{T} value should be close to zero 
but is generally greater. The test rule based on \eqn{T} consists of 
rejecting the null hypothesis if \eqn{T > T^{1- \alpha}}, where \eqn{T^p} 
is the empirical \eqn{p}-percentile of \eqn{T} under the null hypothesis. To
obtain this percentile, we have used bootstrap techniques. See details in 
references.

Note that the models fitted by \code{globaltest} function are specified 
in a compact symbolic form. The \~ operator is basic in the formation 
of such models. An expression of the form \code{y ~ model}  is interpreted as 
a specification that the response \code{y} is modelled by a predictor 
specified symbolically by \code{model}. The possible terms consist of a 
variable name or a variable name and a factor name separated by : operator. 
Such a term is interpreted as the interaction of the continuous variable and 
the factor. However, if \code{smooth = "splines"}, the formula is based on the function
formula.gam of the mgcv package.
}
\examples{
library(npregfast)
data(barnacle)
globaltest(DW ~ RC : F, data = barnacle, der = 1, seed = 130853, nboot = 100)

# globaltest(height ~ s(age, by = sex), data = children, 
# seed = 130853, der = 0, smooth = "splines")


}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\references{
Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.
}

