% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGroupMembers.R
\name{makeGroupMembers}
\alias{makeGroupMembers}
\title{Convenience function to make the initial groupMembers animal list}
\usage{
makeGroupMembers(numGp, currentGroups, candidates, ped, harem, minAge)
}
\arguments{
\item{numGp}{integer value indicating the number of groups that should be
formed from the list of IDs. Default is 1.}

\item{currentGroups}{list of character vectors of IDs of animals currently
assigned to the group. Defaults to character(0) assuming no groups are
existent.}

\item{candidates}{character vector of IDs of the animals available for
use in the group.}

\item{ped}{dataframe that is the `Pedigree`. It contains pedigree
information including the IDs listed in \code{candidates}.}

\item{harem}{logical variable when set to \code{TRUE}, the formed groups
have a single male at least \code{minAge} old.}

\item{minAge}{integer value indicating the minimum age to consider in group
formation. Pairwise kinships involving an animal of this age or younger will
 be ignored. Default is 1 year.}
}
\value{
Initial groupMembers list
}
\description{
Convenience function to make the initial groupMembers animal list
}
