% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_functions.R
\name{pop_pchaz}
\alias{pop_pchaz}
\title{Calculate survival for piecewise constant hazards with change after random time and mixture of subpopulations}
\usage{
pop_pchaz(Tint, lambdaMat1, lambdaMat2, lambdaProgMat, p,
  timezero = FALSE, int_control = list(rel.tol =
  .Machine$double.eps^0.4, abs.tol = 1e-09),
  discrete_approximation = FALSE)
}
\arguments{
\item{Tint}{vector of length \eqn{k+1}, for the boundaries of \eqn{k} time intervals (presumably in days) with piecewise constant hazard. The boundaries should be increasing and the first one should
be \code{0}, the last one should be larger than the assumed trial duration.}

\item{lambdaMat1}{matrix of dimension \eqn{m}-by-\eqn{k}, each row contains the vector of piecewise constant hazards for one subpopulation before the changeing event happens, for the intervals speciefied via \code{Tint}.}

\item{lambdaMat2}{matrix of dimension \eqn{m}-by-\eqn{k}, each row contains the vector piecewise constant hazards for one subpopulation after the changeing event has happened, for the intervals speciefied via \code{Tint}.}

\item{lambdaProgMat}{matrix of dimension \eqn{m}-by-\eqn{k}, each row contains the vector of piecewise constant hazards for one subpopulation for the changeing event, for the intervals speciefied via \code{Tint}.}

\item{p}{vector of length \eqn{m} for relative sizes (proportions) of the subpopulations. They should sum up to 1.}

\item{timezero}{logical, indicating whether after the changing event the timecount, governing which interval in \code{Tint} and which according value in 
\code{lambda2} is used, should restart at zero. This argument is either of length 1 (applying the same to all subgroups) or the same length as the number of subgroups.}

\item{int_control}{A list with additional paramaters to be passed to the  \code{\link{integrate}} function.}

\item{discrete_approximation}{if TRUE, the function uses an approximation based on discretizing the time, instead of integrating. This speeds up the calculations}
}
\value{
A list with class \code{mixpch} containing the following components:
\describe{
\item{\code{haz}}{Values of the hazard function.}
\item{\code{cumhaz}}{Values of the cumulative hazard function.}
\item{\code{S}}{Values of the survival function.}
\item{\code{F}}{Values of the distribution function.}
\item{\code{t}}{Time points for which the values of the different functions are calculated.}
}
}
\description{
Calculates hazard, cumulative hazard, survival and distribution function
	based on hazards that are constant over pre-specified time-intervals
}
\details{
Given \eqn{m} subgroups with relative sizes \eqn{p_1, \dots, p_m} and 
subgroup-specific survival functions \eqn{S{l}(t)}, 
the marginal survival function is the mixture \eqn{S(t)=\sum_{l=1}^m p_l S_{l}(t)}.
Note that the respective hazard function is not a linear combination of the 
subgroup-specific hazard functions. 
It may be calculated by the general relation \eqn{\lambda(t)=-\frac{dS(t)}{dt}\frac{1}{S(t)}}.
In each subgroup, the hazard is modelled as a piecewise constant hazard, with
the possibility to also model disease progression. 
Therefore, each row of the hazard rates is used in \code{\link{subpop_pchaz}}. 
See \code{\link{pchaz}} and \code{\link{subpop_pchaz}}
for more details.
The output includes the function values calculated for all integer time points
 between 0 and the maximum of \code{Tint}.

Note: this function may be very slow in cases where many time points need to be calculated. If this happens, use
\code{discrete_approximation = TRUE}.
}
\examples{
pop_pchaz(Tint = c(0, 40, 100),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2),
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2),
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2),
 p = c(0.8, 0.2),
 timezero = FALSE, discrete_approximation = TRUE)
}
\seealso{
\code{\link{pchaz}}, \code{\link{subpop_pchaz}}, \code{\link{plot.mixpch}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}, Nicolas Ballarini
}
