% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/npIntFactRep.R
\name{npIntFactRep}
\alias{npIntFactRep}
\title{Nonparametric Interaction Tests for Factorial Designs with Repeated Measures}
\usage{
npIntFactRep(dat,rank)
}
\arguments{
\item{dat}{The R data set in wide (one row per subject or ID) format. This set should NOT have any missing values (NA). Missing data should be replaced (e.g., with 'mi', 'mice' or 'Amelia') before running. The data set MUST have subj as name (header) for the (numeric or character) variable for units of observations and MUST have group as name for the (numeric or character) variable for the between factor. The repeated measures (within) factor is named rep.}

\item{rank}{Numbers 0, 1, 2 or 3; resp. for Aligned data Check, Regular, Friedman, or Koch ranks.}
}
\value{
summary of Anova
}
\description{
Nonparametric aligned rank tests for interactions in two-way factorial designs with repeated measures (e.g., Beasley & Zumbo, 2006). There is a choice between 4 tests: (0) CHECK on the alignment for the interaction (1) REGULAR aligned ranks, (2) FRIEDMAN aligned ranks, and (3) KOCH ranks.
}
\details{
Returns an ANOVA table using the 'ezANOVA' function (from the 'ez' package by Michael A. Lawrence), which is well-suited for factorial designs with repeated measures. It yields F- and p-values, along with generalized eta squared (ges) effect size statistics and the sphericity test. Type III sum of squares are calculated. ONLY the resulting values for the INTERACTION group:rep are relevant. There is a choice between 4 rank numbers: (0) Alignment of data (Higgins & Tashtoush, 1994) CHECK (p-values for group and for rep should be = 1.0), (1) REGULAR ranks of aligned data, (2) FRIEDMAN ranks of aligned data, (3) KOCH ranks.
}
\examples{
\dontrun{
dat1 <- read.csv (file="c:/R/wide.csv", head=T)
#REGULAR
npIntFactRep(dat1,1)
}
dat2 <- read.table(header = TRUE, text = "
subj group x1 x2 x3 x4
 p1 a 1 2 3 4
 p2 a 2 2 3 3
 p3 a 1 3 3 4
 p4 b 8 6 4 2
 p5 b 6 6 4 4
 p6 b 8 6 6 2
 p7 c 4 4 4 3
 p8 c 3 3 3 4
 p9 c 3 4 4 2
 ")
#Aligned data check
npIntFactRep(dat2,0)
#FRIEDMAN
npIntFactRep(dat2,2)
dat3 <- read.table(header = TRUE, text = "
subj group 1 2 3 4 5
1 1 1 2 3 4 5
2 1 2 2 3 3 3
3 1 1 3 3 4 2
4 2 8 6 4 2 1
5 2 6 6 4 4 4
6 2 8 6 6 2 3
")
#KOCH Ranks
npIntFactRep(dat3,3)
}
\author{
Jos Feys
}
\references{
Higgins, J.J., & Tashtoush, S. (1994). "An aligned rank transform test for interaction". Nonlinear World, 1, 201-211.
Beasley, T.M., & Zumbo, B.D. (2009). "Aligned rank tests for interactions in split-plot designs: Distributional assumptions and stochastic homogeneity". Journal of Modern Applied Statistical Methods, 8, 16-50.
}

