## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----echo=FALSE, results="hide", message=FALSE--------------------------------
("badger")

## ----normfluodat, eval=F------------------------------------------------------
#  # Normal cases dat(1-4)
#  fpath <- system.file("extdata", "dat_2.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40, rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40, rows_used = c('A','B','C'), interval = 30)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40, rows_used = c('A','B','C'), interval = 60)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')
#  
#  # Extreme cases dat(5-7)
#  fpath <- system.file("extdata", "dat_5.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A'), cols_used = c(1))
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A'), cols_used = c(1,2))
#  
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')

## ----normfluodatlite, eval=F--------------------------------------------------
#  # Normal cases dat(1-4)
#  fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'hundred')
#  normalized_fluo_dat <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one')
#  normalized_fluo_dat <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40)
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')
#  
#  # Extreme cases dat(5-7)
#  fpath <- system.file("extdata", "dat_5.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40)
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatlite(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')

## ----normfluodatfull, eval=F--------------------------------------------------
#  # Normal cases dat(1-4)
#  fpath <- system.file("extdata", "dat_3.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'hundred')
#  normalized_fluo_dat <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one')
#  normalized_fluo_dat <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40)
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')
#  
#  # Extreme cases dat(5-7)
#  fpath <- system.file("extdata", "dat_6.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal', norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'hundred')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'one')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'z-score')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'decimal')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), norm_scale = 'raw')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40)
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluodatfull(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')
#  

## ----normfluordat, eval=F-----------------------------------------------------
#  # Normal cases dat(1-4)
#  fpath <- system.file("extdata", "dat_3.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40)
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')
#  
#  # Extreme cases dat(5-7)
#  fpath <- system.file("extdata", "dat_5.dat", package = "normfluodbf", mustWork = TRUE)
#  normalized_fluo_dat <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), read_direction = 'horizontal')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40)
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3))
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'vertical')
#  normalized_fluo_dat_advv <- normfluordat(dat=fpath, tnp = 1, cycles = 40,rows_used = c('A','B','C'), cols_used = c(1,2,3), read_direction = 'horizontal')

## ----normfluordbf, eval=F-----------------------------------------------------
#  #normfluordbf
#  fpath <- system.file("extdata", "liposomes_214.dbf", package = "normfluodbf", mustWork = TRUE)
#  norm_dbf <- normfluordbf(fpath, norm_scale = 'raw')
#  norm_dbf <- normfluordbf(fpath, norm_scale = 'decimal')
#  norm_dbf <- normfluordbf(fpath, norm_scale = 'one')
#  norm_dbf <- normfluordbf(fpath, norm_scale = 'hundred')
#  norm_dbf <- normfluordbf(fpath, norm_scale = 'z-score')

## ----norm_tidy_dbf, eval=F----------------------------------------------------
#  #norm_tidy_dbf
#  fpath <- system.file("extdata", "liposomes_214.dbf", package = "normfluodbf", mustWork = TRUE)
#  norm_dbf <- norm_tidy_dbf(fpath, norm_scale = 'raw')
#  norm_dbf <- norm_tidy_dbf(fpath, norm_scale = 'decimal')
#  norm_dbf <- norm_tidy_dbf(fpath, norm_scale = 'one')
#  norm_dbf <- norm_tidy_dbf(fpath, norm_scale = 'hundred')
#  norm_dbf <- norm_tidy_dbf(fpath, norm_scale = 'z-score')

## ----time_attribute, eval=F---------------------------------------------------
#  #Time attribute
#  #214
#  time_original = time_attribute(30,8,136,1276,40)
#  norm_dbf = cbind(time_original,norm_dbf)
#  #221
#  time_original = time_attribute(33,8,907,2161,40)
#  norm_dbf = cbind(time_original,norm_dbf)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one', interval = 30, first_end = 8, pause_duration = 136, end_time = 1276)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one', interval = 33, first_end = 8, pause_duration = 0, end_time = 2161)
#  normalized_fluo_dat_advv <- normfluodat(dat=fpath, tnp = 3, cycles = 40,rows_used = c('A','B','C'), read_direction = 'vertical', norm_scale = 'one', interval = 33)
#  for (i in 1:nrow(normalized_fluo_dat_advv)) {
#    for(j in 1:ncol(normalized_fluo_dat_advv))
#      if(j == 1){
#        normalized_fluo_dat_advv[i,j] = normalized_fluo_dat_advv[i,j] + 30
#      }
#  }

## ----ggplot_tnp, eval=F-------------------------------------------------------
#  #Visualize
#  
#  #DAT
#  #z-score
#  ggplot_tnp(normalized_fluo_dat, c('Cycle_Number'), c('A1','B1','C1'),c(0,40),c(-1,3))
#  
#  #hundred
#  ggplot_tnp(normalized_fluo_dat, c('Cycle_Number'), c('A1','B1','C1'),c(0,40),c(0,100))
#  
#  #one
#  ggplot_tnp(normalized_fluo_dat, c('Cycle_Number'), c('A1','B1','C1'),c(0,40),c(0,1))
#  
#  #raw & decimal (sliding scale)
#  ggplot_tnp(normalized_fluo_dat, c('Cycle_Number'), c('A1','B1','C1'),c(0,40),ylim = NULL)
#  
#  #DBF
#  ggplot_tnp(norm_dbf, c('Cycle_Number'), c('A01','B01','C01'),c(0,40),ylim = NULL)
#  ggplot_tnp(norm_dbf, c('Time'), c('A01','B01','C01'),xlim = NULL, ylim = NULL)

