#' Nord and northern-themed color palettes
#'
#' Nord: An arctic, north-bluish color palette.
#' Created for the clean- and minimal flat design pattern to achieve a optimal focus and readability for code syntax highlighting and UI. It consists of four palettes utilizing a total of sixteen, carefully selected, dimmed pastel colors for a eye-comfortable, but yet colorful ambiance.
#'
#' The available palettes are:
#' polarnight
#' snowstorm
#' frost
#' aurora
#'
#' There are also 11 Colour palettes extracted from the works of the [Group of Seven](https://en.wikipedia.org/wiki/Group_of_Seven_(artists)) and one color palette drawn from [Lumina Borealis](https://www.luminaborealis.com/)
#' @export
nord_palettes <- list(#Nord Palette
                      polarnight = c("#2E3440", "#3B4252", "#434C5E", "#4C566A"),
                      snowstorm = c("#D8DEE9", "#E5E9F0", "#ECEFF4"),
                      frost = c("#8FBCBB", "#88C0D0", "#81A1C1", "#5E81AC"),
                      aurora = c("#BF616A", "#D08770", "#EBCB8B", "#A3BE8C", "#B48EAD"),
                      #Lumina Palette
                      lumina = c("#EDDAEB", "#AD8CAE", "#4F93B8", "#306489", "#222B4C"),
                      #G7 Palettes
                      mountain_forms = c("#184860", "#486078", "#d8d8d8", "#484860", "#181830"),
                      silver_mine = c("#4B644B","#647D4B","#E1E1E1","#7D96AF","#647D96"),
                      lake_superior = c("#7D4B19","#C89664","#C87d4B","#4B647D","#324B64","#19324B"),
                      victory_bonds = c("#AF1900","#C83200","#E19600","#193264","#001964"),
                      halifax_harbor = c("#E1C8AF","#C8AF96","#AF967D","#967D7D","#644B64","#4B324b"),
                      moose_pond = c("#4B3232","#7D4B32","#966432","#AF7D32","#E19632","#E1AF4B","#C8C896","#4B4B4B"),
                      algoma_forest = c("#4B4B4B","#967D4B", "#AFAF7D", "#C89632", "#647D64","#96AFAF","#7D96AF"),
                      rocky_mountain = c("#BEBEBE", "#C8C8C8", "#DCD2C8","#D2C8C8", "#BEBEC8", "#B4B4BE"),
                      red_mountain = c("#7D3232", "#7D4B4B", "#7D6464", "#AF967D", "#FAC87D", "#E1AF64","#C8964B","#32324B"),
                      baie_mouton = c("#304890", "#7890A8", "#90A8C0", "#A8A8A8", "#C0C0A8", "#6A7E4F","#304848"),
                      afternoon_prarie = c("#486090", "#6078A8", "#7890A8","#90A8C0","#F0D8C0","#D6BBCF", "#A8C0C0","#C0D8D8","#A8A890")
                      )
