% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPCs.R
\name{vpcfig}
\alias{vpcfig}
\title{Visual Predictive Check (VPC) based on Perl-speaks-NONMEM (PsN) generated VPC files}
\usage{
vpcfig(vpcdir = NULL, vpctab = NULL, vpcresult = NULL,
  strata.names = NULL, strata.subset = NULL, percentile = 10,
  fy = function(y) {     y }, fx = function(x) {     x }, xlab = NULL,
  ylab = NULL, col.data = 8, cex.data = 0.3, pch.data = 3,
  col.line = c("blue", "red", "blue"), lwd.line = c(1, 2, 1),
  lty.line = c(1, 1, 1), col.segm = c("lightblue", "pink", "lightblue"),
  alpha.segm = c(0.5, 0.5, 0.5), type = 3, ...)
}
\arguments{
\item{vpcdir}{Path of directory of the VPC files}

\item{vpctab}{Path to the vpctab-file}

\item{vpcresult}{Path to the vpcresult file}

\item{strata.names}{Character vector for strata names. Must have length equal to number of strata's in vpc files, otherwise ignored.}

\item{strata.subset}{Vector specifying subset of strata to use. Either a vector of index, e.g.  strata.subset=c(1,3),
or a character vector naming which strata to use. See details.}

\item{percentile}{percentile to use, default=10 will display 10% 50% and 90% percentile for model and data.
Percentile argument must match columns included in the vpcresult file.}

\item{fy}{transformation function for y-axis, default to identity function (f(y)=y).}

\item{fx}{transformation function for x-axis, default to identity function (f(x)=x)}

\item{xlab}{label for x-axis, default is IDV as found in vpcresultfile, passed to xyplot.}

\item{ylab}{label for y-axis, default is DV as found in vpcresultfile, passed to xyplot.}

\item{col.data}{color for data points, passed to xyplot, default=8}

\item{cex.data}{cex for data points, passed to xyplot, default=0.3}

\item{pch.data}{plot symbol (pch) for data points, passed to xyplot, default=3}

\item{col.line}{line color for low quartile, median, and high quartile of data, passed to xyplot, default=c("blue","red","blue")}

\item{lwd.line}{line width (lwd) for low quartile, median, and high quartile of data, passed to xyplot, default=c(1,2,1)}

\item{lty.line}{line type (lty) for low quartile, median, and high quartile of data, passed to xyplot, default=c(1,1,1)}

\item{col.segm}{Color of CI regions (low, median and high) for model, passed to xyplot, default=c("lightblue","pink","lightblue")}

\item{alpha.segm}{alpha of CI regions (low, median and high) for model, passed to xyplot, default=c(0.5,0.5,0.5)}

\item{type}{type of VPC plot, 1=display model regions only, 2=as 1 + lines (low, median and high) of data,
3= as 2 + points for data}

\item{...}{Further arguments, passed to xyplot, e.g xlim and ylim axis limits, main for title of plot, abline for adding reference lines, or
scales for formatting axes, see help files for xyplot.
Note: col, cex, pch, lty, lwd, and alpha should not be used.
Instead use the corresponding arguments defined above.}
}
\value{
lattice object of VPC plot
}
\description{
This function creates VPC using output files from the vpc command in Pearl Speaks NONMEM (PsN).
Graphs are generated using the lattice package with many arguments for plot settings are passed
directly to the xyplot function and have the same flexibility as when used in xyplot.
}
\details{
The lattice package is used for creating the VPC and vpcfig have functionality for e.g. modify names of strata,
change layout of panels, use log-scale.

The data used is either specified by the directory of the PsN generated files,
or by specifying the file names of both the vpctab-file and the vpcresult file.
See examples 1 and 2 below.

Names of strata can be changed with the strata.names argument, if strata.names
is NULL the names as specified in the vpcresult file are used.

strata.subset can be used to select a subset of strata, and or to change the order of stratas. Se example 3.
NOTE: strata.subset is matched with strata.names unless strata.names=NULL.
If strata.names=NULL then strata.subset is matched to names as specified in vpcresult file.
Default is to use all strata's (strata.subset=NULL).

The fy and fx arguments can be used to alter the scale of data plotted. For example, using fy=function(y){log(y+1)}
is a convenient way to get log-scale for y-axis but with an off-set to show any values==0. Proper y tick marks
can then be set by using the xyplot argument scales.
}
\examples{

# Get path to the example files included in nonmem2R package
file1 <- system.file("extdata", "vpctab004.dat", package = "nonmem2R")
file2 <- system.file("extdata", "vpc_results.csv", package = "nonmem2R")


# Ex 1, produce VPC with default setting, here specifying both vpctab and vpcresult
vpcfig(vpctab=file1,vpcresult=file2)

\dontrun{
# Ex 2, produce VPC with default setting, here specifying only directory of vpc files
path1<-gsub("vpctab004.dat","",file1)
vpcfig(vpcdir=path1)
}

# Ex 3, produce VPC with i) modifies strata names, ii) strata in reverse order, and
#        iii) labels
strata.names<-c("Group A","Group B")
xlab<-"Time after dose (hrs)"
ylab<-"Plasma Conc(mmol/L)"
vpcfig(vpctab=file1,vpcresult=file2,strata.names=strata.names,strata.subset=2:1,
       xlab=xlab,ylab=ylab)
}

