% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.plot.R
\name{eval.plot}
\alias{eval.plot}
\title{Visualization of Evaluation Criteria}
\usage{
eval.plot(
  x,
  criteria = "all",
  style = "greys",
  opt.col = "red",
  main = "Cluster Evaluation",
  ...
)
}
\arguments{
\item{x}{An output of the "nomclust" object containing the \code{eval} and \code{opt} components.}

\item{criteria}{A character string or character vector specifying the criteria that are going to be visualized. It can be selected one particular criterion, a vector of criteria, or all the available criteria by typing \code{"all"}.}

\item{style}{A character string or a vector of colors defines the graphical style of the produced plots. There are two predefined styles in the \bold{nomclust} package, namely \code{"greys"} and \code{"dark"}, but a custom color scheme can be set by a user as a vector of a length four.}

\item{opt.col}{An argument specifying a color that is used for the optimal number of clusters identification.}

\item{main}{A character string with the chart title.}

\item{...}{Other graphical arguments compatible with the generic \code{plot()} function.}
}
\value{
The function returns a series of up to eight plots with evaluation criteria values and the graphical indication of the optimal numbers of clusters (for AIC, BIC, BK, PSFE, PSFM, SI).
}
\description{
The function visualizes the values of up to eight evaluation criteria for the range of cluster solutions defined by the user in the \bold{nomclust}, \bold{evalclust} or \bold{nomprox} functions.
 It also indicates the optimal number of clusters determined by these criteria. The charts for the evaluation criteria in the \bold{nomclust} package.
}
\details{
The function can display up to eight evaluation criteria. Namely, Within-cluster mutability coefficient (WCM), Within-cluster entropy coefficient (WCE),
Pseudo F Indices based on the mutability (PSFM) and the entropy (PSFE), Bayesian (BIC), and Akaike (AIC) information criteria for categorical data, the BK index, and the silhouette index (SI).
\cr
}
\examples{
# sample data
data(data20)

# creating an object with results of hierarchical clustering 
hca.object <- nomclust(data20, measure = "iof", eval = TRUE)

# a default series of plots
eval.plot(hca.object)

# changing the color indicating the optimum number of clusters
eval.plot(hca.object, opt.col= "darkorange")

# selecting only AIC and BIC criteria with the dark style
eval.plot(hca.object, criteria = c("AIC", "BIC"), style = "dark")

# selecting only SI
eval.plot(hca.object, criteria = "SI")

}
\seealso{
\code{\link[nomclust]{dend.plot}}, \code{\link[nomclust]{nomclust}}, \code{\link[nomclust]{evalclust}}, \code{\link[nomclust]{nomprox}}.
}
\author{
Jana Cibulkova and Zdenek Sulc. \cr Contact: \email{jana.cibulkova@vse.cz}
}
