% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/good1.R
\name{good1}
\alias{good1}
\title{Goodall 1 (G1) Measure}
\usage{
good1(data)
}
\arguments{
\item{data}{A \emph{data.frame} or a \emph{matrix} with cases in rows and variables in colums.}
}
\value{
The function returns an object of class "dist".
\cr
}
\description{
A function for calculation of a proximity (dissimilarity) matrix based on the G1 similarity measure.
}
\details{
The Goodall 1 similarity measure was presented in (Boriah et al., 2008).
It is a simple modification of the original Goodall measure (Goodall, 1966). The measure assigns higher weights to infrequent matches.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.good1 <- good1(data20)

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Goodall V.D. (1966). A new similarity index based on probability. Biometrics, 22(4), p. 882.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
