% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbGetQuery}
\alias{dbGetQuery}
\alias{dbGetQuery,AthenaConnection,character-method}
\title{Send query, retrieve results and then clear result set}
\usage{
\S4method{dbGetQuery}{AthenaConnection,character}(conn, statement, statistics = FALSE, unload = athena_unload(), ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{statistics}{If set to \code{TRUE} will print out AWS Athena statistics of query.}

\item{unload}{boolean input to modify `statement` to align with \href{https://docs.aws.amazon.com/athena/latest/ug/unload.html}{AWS Athena UNLOAD},
default is set to \code{FALSE}.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbGetQuery()} returns a dataframe.
}
\description{
Send query, retrieve results and then clear result set
}
\note{
If the user does not have permission to remove AWS S3 resource from AWS Athena output location, then an AWS warning will be returned.
      It is better use query caching \code{\link{noctua_options}} so that the warning doesn't repeatedly show.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())

# Sending Queries to Athena
dbGetQuery(con, "show databases")

# Disconnect conenction
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbGetQuery}}
}
