% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZTkinv}
\alias{funsZTkinv}
\alias{ZTkinv}
\alias{ZTkinv.sim}
\title{Z-Test for Cuzick and Edwards \eqn{T_k^{inv}} statistic}
\usage{
ZTkinv(
  dat,
  k,
  cc.lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  case.lab = NULL,
  Nvar.sim = 1000,
  ...
)

ZTkinv.sim(
  dat,
  k,
  cc.lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  case.lab = NULL,
  Nsim = 1000
)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point, 
used in both functions.}

\item{k}{Integer specifying the number of the closest controls to subject \eqn{i}, used in both functions.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control, used in both functions.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"},
used in both functions.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for Cuzick and Edwards \eqn{T_k^{inv}} statistic. Used in both functions.}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}, used in both functions.}

\item{Nvar.sim}{The number of simulations, i.e., the number of resamplings under the RL scheme to estimate the 
variance of Tkinv, used in \code{ZTkinv} only.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. Used in \code{ZTkinv} only.}

\item{Nsim}{The number of simulations, i.e., the number of resamplings under the RL scheme to estimate the 
\eqn{T_k^{inv}} values, used in \code{ZTkinv.sim} only.}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for the Cuzick and Edwards \eqn{T_k^{inv}} test}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative. In \code{ZTkinv}
this is computed using the standard normal distribution, while in \code{ZTkinv.sim}, it is based on which percentile
the observed \eqn{T_k^{inv}} value is among the generated \eqn{T_k^{inv}} values.}
\item{conf.int}{Confidence interval for the Cuzick and Edwards \eqn{T_k^{inv}} value
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.}
\eqn{z}-critical values are used in the construction of the confidence interval in \code{ZTkinv}, 
while the percentile values are used in the generated sample of \eqn{T_k^{inv}} values in \code{ZTkinv.sim} 
\item{estimate}{Estimate of the parameter, i.e., the Cuzick and Edwards \eqn{T_k^{inv}} value.}
\item{null.value}{Hypothesized null value for the Cuzick and Edwards \eqn{T_k^{inv}} value
which is \eqn{k n_1 (n_1-1)/(n_0+1)} under RL, where the number of cases are denoted as \eqn{n_1} and number of controls as \eqn{n_0}.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}}
}
\description{
Two functions: \code{ZTkinv} and \code{ZTkinv.sim}, each of which is an object of class \code{"htest"} performing a
\eqn{z}-test for Cuzick and Edwards \eqn{T_k^{inv}} test statistic. See \code{\link{ceTkinv}} for a description of 
\eqn{T_k^{inv}} test statistic.

The function \code{ZTkinv} performs a \eqn{Z}-test for \eqn{T_k^{inv}} using asymptotic normality with a simulation estimated
variance under RL of cases and controls to the given points.
And the function \code{ZTkinv.sim} performs test for\eqn{T_k^{inv}} based on MC simulations under the RL hypothesis.
 
Asymptotic normality for the \eqn{T_k^{inv}} is not established yet, but this seems likely according to 
\insertCite{cuzick:1990;textual}{nnspat}. 
If asymptotic normality holds, it seems a larger sample size would be needed before this becomes
an effective approximation.
Hence the simulation-based test \code{ZTkinv.sim} is recommended for use to be safe. 
When \code{ZTkinv} is used, this is also highlighted with the warning "asymptotic normality of \eqn{T_k^{inv}} is not yet established, 
so simulation-based test is recommended".

All arguments are common for both functions, except for \dots, Nvar.sim which are used in \code{ZTkinv} only,
and \code{Nsim}, which is used in \code{ZTkinv.sim} only.

The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL}, 
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's 
and 1's accordingly.
The argument \code{Nvar.sim} represents the number of resamplings (without replacement) in the
RL scheme, with default being \code{1000} for estimating the variance of \eqn{T_k^{inv}} statistic in \code{ZTkinv}.
The argument \code{Nsim} represents the number of resamplings (without replacement) in the
RL scheme, with default being \code{1000} for estimating the \eqn{T_k^{inv}} values in \code{ZTkinv.sim}.

Both functions might take a very long time when data size is large or \code{Nsim} is large.

See also (\insertCite{cuzick:1990;textual}{nnspat}) and the references therein.
}
\examples{
n<-10 #try also 20, 50, 100
set.seed(123)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
k<-2

ZTkinv(Y,k,cls)
ZTkinv(Y,k,cls+1,case.lab = 2,alt="l")
#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ZTkinv(Y,k,fcls,case.lab="a")

n<-10 #try also 20, 50, 100
set.seed(123)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
k<-2 # try also 3,5

ZTkinv.sim(Y,k,cls)
ZTkinv.sim(Y,k,cls,conf=.9,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ZTkinv.sim(Y,k,fcls,case.lab="a")

#with k=1
ZTkinv.sim(Y,k=1,cls)
ZTrun(Y,cls)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTkinv}} and \code{\link{EV.Tkinv}}
}
\author{
Elvan Ceyhan
}
