% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{ZTcomb}
\alias{ZTcomb}
\title{\eqn{Z}-test for Cuzick and Edwards \eqn{T_{comb}} statistic}
\usage{
ZTcomb(
  dat,
  cc.lab,
  klist,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  case.lab = NULL,
  nonzero.mat = TRUE,
  asy.cov = FALSE,
  ...
)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{klist}{\code{list} of integers specifying the indices of the \eqn{T_k} values used in obtaining the \eqn{T_{comb}}.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for Cuzick and Edwards \eqn{T_{comb}} statistic}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}.}

\item{nonzero.mat}{A logical argument (default is \code{TRUE}) to determine whether the \eqn{A} matrix or the matrix of
nonzero locations of the \eqn{A} matrix will be used in the computation of covariance of \eqn{T_k} values forming the
\code{T_{comb}} statistic (argument is passed on to \code{covTcomb}). If \code{TRUE} the nonzero location matrix is used,
otherwise the \eqn{A} matrix itself is used.}

\item{asy.cov}{A logical argument (default is \code{FALSE}) to determine whether asymptotic or exact (i.e., finite
sample) covariances between \eqn{T_k} and \eqn{T_l} values are to be used to obtain the entries of the covariance matrix.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for the Cuzick and Edwards \eqn{T_{comb}} test}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the Cuzick and Edwards \eqn{T_{comb}} value
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{estimate}{Estimate of the parameter, i.e., the Cuzick and Edwards \eqn{T_{comb}} value.}
\item{null.value}{Hypothesized null value for the Cuzick and Edwards \eqn{T_{comb}} value
which is \eqn{E[T_{comb}]} for this function, which is the output of \code{EV.Tcomb} function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}}
}
\description{
An object of class \code{"htest"} performing a \eqn{z}-test for Cuzick and Edwards \eqn{T_{comb}} test statisticin disease clustering,
where \eqn{T_{comb}} is a linear combination of some \eqn{T_k} tests. 

For disease clustering, \insertCite{cuzick:1990;textual}{nnspat} developed a \eqn{k}-NN test \eqn{T_k} based on 
number of cases among \eqn{k} NNs of the case points, and also proposed a test combining various \eqn{T_k} tests,
denoted as \eqn{T_{comb}}.

See page 87 of (\insertCite{cuzick:1990;textual}{nnspat}) for more details.

Under RL of \eqn{n_1} cases and \eqn{n_0} controls to the given locations in the study region,
\eqn{T_{comb}} approximately has \eqn{N(E[T_{comb}],Var[T_{comb}])} distribution for large \eqn{n_1}.

The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL}, 
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's 
and 1's accordingly. 

The argument \code{klist} is the \code{vector} of integers specifying the indices of the \eqn{T_k} values used
in obtaining the \eqn{T_{comb}}.

The logical argument \code{nonzero.mat} (default=\code{TRUE}) is for using the \eqn{A} matrix if \code{FALSE} or just the matrix of nonzero
locations in the \eqn{A} matrix (if \code{TRUE}) in the computations.

The logical argument \code{asy.cov} (default=\code{FALSE}) is for using the asymptotic covariance or the exact (i.e. finite
sample) covariance for the vector of \eqn{T_k} values used in \code{Tcomb} in the standardization of \eqn{T_{comb}}.
If \code{asy.cov=TRUE}, the asymptotic covariance is used, otherwise the exact covariance is used.

See also (\insertCite{ceyhan:SiM-seg-ind2014,cuzick:1990;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))

kl<-sample(1:5,3) #try also sample(1:5,2)
ZTcomb(Y,cls,kl)
ZTcomb(Y,cls,kl,method="max")

ZTcomb(Y,cls,kl,nonzero.mat=FALSE)
ZTcomb(Y,cls+1,kl,case.lab = 2,alt="l")
ZTcomb(Y,cls,kl,conf=.9,alt="g")
ZTcomb(Y,cls,kl,asy=TRUE,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ZTcomb(Y,fcls,kl,case.lab="a")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Tcomb}}, \code{\link{EV.Tcomb}}, and \code{\link{covTcomb}}
}
\author{
Elvan Ceyhan
}
