% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_inla.R
\name{nma_inla}
\alias{nma_inla}
\title{Fitting a network meta-analysis model using INLA}
\usage{
nma_inla(
  datINLA,
  likelihood = NULL,
  fixed.par = c(0, 1000),
  tau.prior = "uniform",
  tau.par = c(0, 5),
  kappa.prior = "uniform",
  kappa.par = c(0, 5),
  mreg = FALSE,
  type = "consistency",
  verbose = FALSE,
  inla.strategy = "simplified.laplace",
  improve.hyperpar.dz = 0.75,
  correct = FALSE,
  correct.factor = 10,
  improve.hyperpar = TRUE
)
}
\arguments{
\item{datINLA}{An object of \code{create_INLA_dat}}

\item{likelihood}{The likelihood to be used.}

\item{fixed.par}{A numerical vector specifying the parameter of the normal prior
density for basic parameters, first value is parameter for mean, second is for variance.}

\item{tau.prior}{A string specifying the prior density for the heterogeneity standard deviation,
options are 'uniform' for uniform prior and 'half-normal' for half-normal prior.}

\item{tau.par}{A numerical vector specifying the parameter of the prior
density for heterogenety stdev.
\itemize{
  \item \code{var.par = c(u, l)}: \code{u} is lower bound and \code{l} is upper
  bound when \code{var.prior = 'uniform'}.
  \item \code{var.par = c(m, v)}: \code{m} is mean and \code{v} is variance
  when \code{var.prior = 'half-normal'}.
}}

\item{kappa.prior}{A string specifying the prior density for the inconsistency standard deviation,
options are 'uniform' for uniform prior and 'half-normal' for half-normal prior.}

\item{kappa.par}{A numerical vector specifying the parameter of the prior.
density for inconsistency stdev. The definition of the priors is the same as for \code{tau.par}.}

\item{mreg}{Logical indicating whether covariate(s) should be incorporated to fit a
network meta-regression model, default \code{FALSE}.}

\item{type}{A string indicating the type of the model, options are "FE", "consistency" and "jackson".}

\item{verbose}{Logical indicating whether the program should run in a verbose model, default \code{FALSE}.}

\item{inla.strategy}{A string specfying the strategy to use for the approximations of INLA;
one of 'gaussian', 'simplified.laplace' (default) or 'laplace', see \code{?INLA::control.inla}.}

\item{improve.hyperpar.dz}{Step length in the standardized scale used in the construction of the grid, default 0.75,
see \code{INLA::inla.hyperpar}. Not used if \code{mod = 'FE'}.}

\item{correct}{Logical Add correction for the Laplace approximation, default \code{FALSE},
see \code{INLA::inla.hyperpar}. Not used if \code{mod = 'FE'}.}

\item{correct.factor}{Numerical Factor used in adjusting the correction factor if \code{correct=TRUE}, default 10,
see \code{INLA::inla.hyperpar}. Not used if \code{mod = 'FE'}.}

\item{improve.hyperpar}{Improve the estimates of the posterior marginals for the hyperparameters
 of the model using the grid integration strategy, default \code{TRUE}.
see \code{INLA::inla.hyperpar}.}
}
\value{
\code{nma_inla} returns a \code{nma_inla} object.
}
\description{
\code{nma_inla} fits a network meta-analysis model using INLA.
}
\details{
The following likelihood types are supported
\itemize{
  \item \code{normal}: for continuous (mean difference) data.

  Required coloumns: \code{[mean, std.err]}

  Result: relative mean difference
  \item \code{binomial}: for dichotomous data.

  Required coloumns: \code{[responders, sampleSize]}

  Result: log odds ratio
  \item \code{normal}: for event-rate (survival) data.

  Required coloumns: \code{[responders, exposure]}

  Result: log hazard ratio
  }
The following model types are supported
\itemize{
  \item \code{FE}, ordinary fixed effect model, assuming homogeneity between trials
  (Dias et al., 2013)
  \item \code{consistency}, ordinary consistency model, assuming consistency in the
  network. (Jackson et al., 2014)
  \item \code{jackson}, the design-by-treatment interaction model with random
  inconsistency parameters. (Jackson et al., 2014)
  }
}
\examples{
SmokdatINLA <- create_INLA_dat(dat = Smokdat, armVars = c('treatment' = 't', 'responders' = 'r'
,'sampleSize' = 'n'), nArmsVar = 'na')
\dontrun{
## Fitting a consistency model
if(requireNamespace('INLA', quietly = TRUE)){
 require('INLA', quietly = TRUE)
fit.Smok.cons.INLA <- nma_inla(SmokdatINLA, likelihood = 'binomial', type = 'consistency',
tau.prior = 'uniform', tau.par = c(0, 5))
}
}

}
