% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSbg4rp.R
\name{SSbg4rp}
\alias{SSbg4rp}
\alias{bg4rp}
\title{self start for the reparameterized Beta growth function with four parameters}
\usage{
bg4rp(time, w.max, lt.e, ldtm, ldtb)

SSbg4rp(time, w.max, lt.e, ldtm, ldtb)
}
\arguments{
\item{time}{input vector (x) which is normally \sQuote{time}, the smallest value should be close to zero.}

\item{w.max}{value of weight or mass at its peak}

\item{lt.e}{log of the time at which the maximum weight or mass has been reached.}

\item{ldtm}{log of the difference between time at which the weight or mass reaches its peak and half its peak.}

\item{ldtb}{log of the difference between time at which the weight or mass reaches its peak and when it starts growing}
}
\value{
bg4rp: vector of the same length as x (time) using the beta growth function with four parameters
}
\description{
Self starter for Beta Growth function with parameters w.max, lt.m, ldt
}
\details{
For details see the publication by Yin et al. (2003) \dQuote{A Flexible Sigmoid Function of Determinate Growth}.
This is a reparameterization of the beta growth function (4 parameters) with guaranteed constraints, so it is expected to 
behave numerically better than \code{\link{SSbgf4}}.

Reparameterizing the four parameter beta growth
\itemize{
  \item ldtm = log(t.e - t.m)
  \item ldtb = log(t.m - t.b)
  \item t.e = exp(lt.e)
  \item t.m = exp(lt.e) - exp(ldtm)
  \item t.b = (exp(lt.e) - exp(ldtm)) - exp(ldtb)
}

The form of the equation is: \deqn{w.max * (1 + (exp(lt.e) - time)/exp(ldtm)) * ((time - (exp(lt.e) - exp(ldtb)))/exp(ldtb))^(exp(ldtb)/exp(ldtm))}
This is a reparameterized version of the Beta-Growth function in which the parameters are unconstrained, but they are expressed in the log-scale.
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:100
y <- bg4rp(x, 20, log(70), log(30), log(20)) + rnorm(100, 0, 1)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSbg4rp(x, w.max, lt.e, ldtm, ldtb), data = dat)
## We are able to recover the original values
exp(coef(fit)[2:4])
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
