% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSblin.R
\name{SSblin}
\alias{SSblin}
\alias{blin}
\title{self start for a bilinear Function}
\usage{
blin(x, a, b, xs, c)

SSblin(x, a, b, xs, c)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the first-phase slope}

\item{xs}{break-point of transition between first-phase linear and second-phase linear}

\item{c}{the second-phase slope}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

blin: vector of the same length as x using the bilinear function
}
\description{
Self starter for a bilinear function with parameters a (intercept), b (first slope), xs (break-point), c (second slope)
}
\details{
This is a special case with just two parts but a more general approach is to consider a segmented 
function with several breakpoints and linear segments. Splines would be even more general. Also this
model assumes that there is a break-point that needs to be estimated.
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:30
y <- blin(x, 0, 0.75, 15, 1.75) + rnorm(30, 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSblin(x, a, b, xs, c), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
\seealso{
package \pkg{segmented}.
}
