% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TVC.output_helper.R
\name{getTVC.output}
\alias{getTVC.output}
\title{Extract Point Estimates And Standard Errors of Latent Growth Curve Model Or Latent Change Score Model
with a Time-varying Covariate and Time-invariant Covariates (If Any)}
\usage{
getTVC.output(model, curveFun, records, y_model, decompose, growth_TIC, names)
}
\arguments{
\item{model}{An object representing a fitted latent growth curve model or a latent change score model with a TVC.
It takes the value passed from \code{getTVCmodel()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getTVCmodel()}.}

\item{records}{A numeric vector specifying the indices of the observed study waves. It takes the value passed from
\code{getTVCmodel()}.}

\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes the value passed from \code{getTVCmodel()}.}

\item{decompose}{An integer specifying the decomposition option for temporal states. Supported values include \code{0} (no
decomposition), \code{1} (decomposition with interval-specific slopes as temporal states), \code{2} (decomposition with interval-
specific changes as temporal states), and \code{3} (decomposition with change-from-baseline as temporal states). It takes the
value passed from \code{getTVCmodel()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) that account for the
variability of growth factors, if any. It takes the value passed from \code{getTVCmodel()}.}

\item{names}{A character vector specifying parameter names. It takes the value passed from \code{getTVCmodel()}.}
}
\value{
A data frame containing the point estimates and standard errors for parameters of a latent growth
curve model or a latent change score model with a time-varying covariate and time-invariant covariates (if
any).
}
\description{
This function computes and returns a data frame containing point estimates and standard errors for the
parameters of a latent growth curve model or a latent change score model with a time-varying covariate
and time-invariant covariates (if any)
}
\keyword{internal}
