% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageHeaping.R
\name{ageHeaping}
\alias{ageHeaping}
\title{Age-heaping analysis}
\usage{
ageHeaping(x, divisor = 12)
}
\arguments{
\item{x}{Vector of ages}

\item{divisor}{Divisor (usually 5, 6, 10, or 12); default is 12}
}
\value{
A list of class "ageHeaping" with:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{X2} \tab Chi-squared test statistic \cr
   \emph{df} \tab Degrees of freedom or Chi-squared test \cr
   \emph{p} \tab \code{p-value} for Chi-squared test \cr
   \emph{tab} \tab Table of remainders (for \verb{x \\\%\\\%} divisor) \cr
   \emph{pct} \tab Table of proportions (\verb{\\\%}) of remainders for \verb{x \\\%\\\%} divisor) \cr
}
}
\description{
Age heaping is the tendency to report children's ages to the nearest year or
adults’ ages to the nearest multiple of five or ten years. Age heaping is
very common. This is a major reason why data from nutritional anthropometry
surveys is often analysed and reported using broad age groups.
}
\examples{
# Test for age heaping using SMART survey data in Kabul, Afghanistan (dp.ex02)
# using a divisor of 12
svy <- dp.ex02
ah12 <- ageHeaping(svy$age)
ah12

# Test for age heaping using SMART survey data in Kabul, Afthanistan (dp.ex02)
# using a divisor of 6
ah6 <- ageHeaping(svy$age, divisor = 6)
ah6

}
