% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dDispersal_exp.R
\name{dDispersal_exp}
\alias{dDispersal_exp}
\alias{rDispersal_exp}
\title{Bivariate exponential dispersal distribution for activity centers}
\usage{
dDispersal_exp(x, s, rate, log)

rDispersal_exp(n, s, rate)
}
\arguments{
\item{x}{Bivariate activity center coordinates (at time t+1).}

\item{s}{Current location of the bivariate activity center (at time t).}

\item{rate}{Rate parameter of the exponential distribution for dispersal distance.}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate.  Only n = 1 is supported.}
}
\value{
The log-probability value associated with the bivariate activity center location x, given the current activity center s, and the rate parameter of the exponential dispersal distance distribution.
}
\description{
The dDispersal_exp distribution is a bivariate distribution which can be used to model the latent bivariate activity centers (ACs) of individuals in a population.  This distribution models the situation when individual AC dispersal is uniform in direction (that is, dispersal occurs in a direction theta, where theta is uniformly distributed on [-pi, pi]), and with an exponential distribution for the radial dispersal distance.
}
\details{
The dDispersal_exp distribution models the location of an AC at time (t+1), conditional on the previous AC location at time (t) and the rate parameter (rate) of the exponential distribution for dispersal distance.
}
\examples{
## define model code
code <- nimbleCode({
    lambda ~ dgamma(0.001, 0.001)
    for(i in 1:N) {
        AC[i, 1, 1] ~ dunif(0, 100)
        AC[i, 2, 1] ~ dunif(0, 100)
        for(t in 2:T) {
            AC[i, 1:2, t+1] ~ dDispersal_exp(s = AC[i, 1:2, t], rate = lambda)
        }
    }
})

constants <- list(N = 10, T = 6)

## create NIMBLE model object
Rmodel <- nimbleModel(code, constants)

## use model object for MCMC, etc.

}
\author{
Daniel Turek
}
