% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/externalCalls.R
\name{nimbleRcall}
\alias{nimbleRcall}
\title{Make an R function callable from compiled nimbleFunctions (including nimbleModels).}
\usage{
nimbleRcall(
  prototype,
  returnType,
  Rfun,
  where = getNimbleFunctionEnvironment()
)
}
\arguments{
\item{prototype}{Argument type information for Rfun.  This can be provided as an R function using \code{nimbleFunction} type declarations or as a list of \code{nimbleType} objects.}

\item{returnType}{Return object type information.  This can be provided similarly to \code{prototype} as either a \code{nimbleFunction} type declaration or as a \code{nimbleType} object.  In the latter case, the name will be ignored. If there is no return value this should be \code{void()}.}

\item{Rfun}{The name of an R function to be called from compiled nimbleFunctions.}

\item{where}{An optional \code{where} argument passed to \code{setRefClass} for where the reference class definition generated for this nimbleFunction will be stored.  This is needed due to R package namespace issues but should never need to be provided by a user.}
}
\value{
A \code{nimbleFunction} that wraps a call to \code{Rfun} with type-declared arguments and return object.
}
\description{
Normally compiled nimbleFunctions call other compiled nimbleFunctions.  nimbleRcall enables any R function (with viable argument types and return values) to be called (and evaluated in R) from compiled nimbleFunctions.
}
\details{
The \code{nimbleFunction} returned by \code{nimbleRcall} can be used in other \code{nimbleFunction}s.  When called from a compiled \code{nimbleFunction} (including from a model), arguments will be copied according to the declared types, the function named by \code{Rfun} will be called, and the returned object will be copied if necessary.  The example below shows use of an R function in a compiled \code{nimbleModel}.

A \code{nimbleFunction} returned by \code{nimbleRcall} can only be used in a compiled \code{nimbleFunction}.  \code{Rfun} itself should work in an uncompiled \code{nimbleFunction}.
}
\examples{
\dontrun{
## Say we want an R function that adds 2 to every value in a vector
add2 <- function(x) {
   x + 2 
}
Radd2 <- nimbleRcall(function(x = double(1)){}, Rfun = 'add2',
returnType = double(1))
demoCode <- nimbleCode({
    for(i in 1:4) {x[i] ~ dnorm(0,1)} 
    z[1:4] <- Radd2(x[1:4])
})
demoModel <- nimbleModel(demoCode, inits = list(x = rnorm(4)),
check = FALSE, calculate = FALSE)
CdemoModel <- compileNimble(demoModel)
}
}
\seealso{
\code{\link{nimbleExternalCall}} for calling externally provided C (or other) compiled code.
}
\author{
Perry de Valpine
}
