% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{strip_game_id}
\alias{strip_game_id}
\title{Strip the game ID into the season ID, game type ID, and game number for all
the events (plays) in a play-by-play}
\usage{
strip_game_id(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions}
}
\value{
data.frame with one row per event (play) and added columns:
\code{seasonId}, \code{gameTypeId}, and \code{gameNumber}
}
\description{
\code{strip_game_id()} strips the game ID into the season ID, game type ID, and
game number for all the events (plays) in a play-by-play.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                  <- gc_play_by_play()
  test_game_id_stripped <- strip_game_id(test)
}
}
