% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{get_files_mtime}
\alias{get_files_mtime}
\title{Function to check file last change time and 
according the requirement to return check value}
\usage{
get_files_mtime(input_files = NULL, files_dir = NULL, pattern = ".*.txt",
  return_mtime = TRUE, return_check = TRUE,
  check_time_fun = function(files_mtime) {     all(files_mtime ==
  files_mtime[1]) })
}
\arguments{
\item{input_files}{Basename of files that need to be check, default is NULL 
and use the regular expression pattern to select files}

\item{files_dir}{Directory name of input files}

\item{pattern}{Use regular expression to select files in files_dir}

\item{return_mtime}{Logical indicating wheather to return files modification times}

\item{return_check}{Logical indicating wheather to return file times check status}

\item{check_time_fun}{Function to check files time, default is all equal}
}
\description{
Function to check file last change time and 
according the requirement to return check value
}
\examples{
file_a <- tempfile()
file_b <- tempfile()
file.create(c(file_a, file_b))
get_files_mtime(input_files = c(file_a, file_b), return_mtime = TRUE)
}
